/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.faces;

import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.richfaces.resource.optimizer.faces.CurrentResourceContext;
import org.richfaces.resource.optimizer.strings.Constants;

public class ResourceELResolver
extends ELResolver {
    private void checkBaseAndProperty(Object base, Object property) {
        if (base == null && property == null) {
            throw new PropertyNotFoundException("base & property are null");
        }
    }

    private String skipEqualPathSegments(Iterator<String> path, Iterator<String> basePath) {
        while (path.hasNext()) {
            String basePathSeg;
            String pathSeg = path.next();
            if (basePath.hasNext() && (basePathSeg = basePath.next()).equals(pathSeg)) continue;
            return pathSeg;
        }
        return null;
    }

    private String relativize(String path, String basePath) {
        Iterator<String> pathItr = Constants.SLASH_SPLITTER.split((CharSequence)path).iterator();
        Iterator<String> basePathItr = Constants.SLASH_SPLITTER.split((CharSequence)basePath).iterator();
        ArrayList resultPathSegments = Lists.newArrayList();
        String firstNonMatchedSegment = this.skipEqualPathSegments(pathItr, basePathItr);
        while (basePathItr.hasNext()) {
            basePathItr.next();
            resultPathSegments.add("..");
        }
        if (firstNonMatchedSegment != null) {
            resultPathSegments.add(firstNonMatchedSegment);
        }
        while (pathItr.hasNext()) {
            resultPathSegments.add(pathItr.next());
        }
        return Constants.SLASH_JOINER.join((Iterable)resultPathSegments);
    }

    public Object getValue(ELContext context, Object base, Object property) {
        this.checkBaseAndProperty(base, property);
        if (base instanceof ResourceHandler) {
            Resource resource;
            ResourceHandler handler = (ResourceHandler)base;
            String prop = (String)property;
            if (!prop.contains(":")) {
                resource = handler.createResource(prop);
            } else {
                String[] parts = prop.split(":");
                if (parts.length != 2) {
                    throw new ELException(MessageFormat.format("Invalid resource format. Property {0} contains more than one colon (:)", prop));
                }
                resource = handler.createResource(parts[1], parts[0]);
            }
            context.setPropertyResolved(true);
            if (resource != null) {
                String requestPath = resource.getRequestPath();
                FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
                Resource contextResource = CurrentResourceContext.getInstance(facesContext).getResource();
                if (contextResource != null) {
                    requestPath = this.relativize(requestPath, contextResource.getRequestPath());
                }
                return requestPath;
            }
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        this.checkBaseAndProperty(base, property);
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        this.checkBaseAndProperty(base, property);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        this.checkBaseAndProperty(base, property);
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }
}

