/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.dashboard.workflow;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItem;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItemImpl;

@Name(value="taskDashBoardActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class TaskDashBoardActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient TaskService taskService;
    protected Collection<DashBoardItem> currentUserTasks;
    @In(required=false)
    protected transient Principal currentUser;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    private static final Log log = LogFactory.getLog(TaskDashBoardActions.class);

    public Collection<DashBoardItem> computeDashboardItems() {
        if (this.currentUserTasks == null) {
            this.currentUserTasks = new ArrayList<DashBoardItem>();
            List tasks = this.taskService.getCurrentTaskInstances(this.documentManager);
            if (tasks != null) {
                for (Task task : tasks) {
                    if (task.hasEnded().booleanValue() || task.isCancelled().booleanValue()) continue;
                    DocumentModel doc = this.taskService.getTargetDocumentModel(task, this.documentManager);
                    if (doc != null && !"deleted".equals(doc.getCurrentLifeCycleState())) {
                        this.currentUserTasks.add((DashBoardItem)new DashBoardItemImpl(task, doc, this.localeSelector.getLocale()));
                        continue;
                    }
                    log.warn((Object)String.format("User '%s' has a task of type '%s' on a missing or deleted document", this.currentUser.getName(), task.getName()));
                }
            }
        }
        return this.currentUserTasks;
    }

    @Observer(value={"workflowProcessEnded", "workflowNewProcessStarted", "workflowTaskStart", "workflowTaskStop", "workflowTaskRejected", "workflowUserAssignmentChanged", "workflowTaskCompleted", "workflowTaskRemoved", "workItemsListLoaded", "workflowTasksComputed", "workflowAbandoned", "workflowProcessCanceled", "domainSelectionChanged", "documentPublicationRejected", "documentPublished"}, create=false)
    @BypassInterceptors
    public void invalidateDashboardItems() {
        this.currentUserTasks = null;
    }

    public String refreshDashboardItems() {
        this.currentUserTasks = null;
        return null;
    }
}

