/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.liveedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.runtime.api.Framework;

@Scope(value=ScopeType.SESSION)
@Name(value="liveEditClientConfig")
@Install(precedence=10)
public class LiveEditClientConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LiveEditClientConfig.class);
    protected Boolean clientHasLiveEditInstalled;
    protected List<String> advertizedLiveEditableMimeTypes;
    protected static String liveEditConfigPolicy;
    public static final String LE_MIME_TYPE = "application/x-nuxeo-liveedit";
    public static final String LE_CONFIG_PROPERTY = "org.nuxeo.ecm.platform.liveedit.config";
    public static final String LE_CONFIG_CLIENTSIDE = "client";
    public static final String LE_CONFIG_SERVERSIDE = "server";
    public static final String LE_CONFIG_BOTHSIDES = "both";

    protected void detectLiveEditClientConfig() {
        this.clientHasLiveEditInstalled = false;
        this.advertizedLiveEditableMimeTypes = new ArrayList<String>();
        if (this.getLiveEditConfigurationPolicy().equals(LE_CONFIG_SERVERSIDE)) {
            this.clientHasLiveEditInstalled = true;
            return;
        }
        FacesContext fContext = FacesContext.getCurrentInstance();
        if (fContext == null) {
            log.error((Object)"unable to fetch facesContext, can not detect liveEdit client config");
        } else {
            String[] accepted;
            Map headers = fContext.getExternalContext().getRequestHeaderMap();
            String accept = (String)headers.get("Accept");
            if (accept == null) {
                return;
            }
            for (String acceptHeader : accepted = accept.split(",")) {
                String[] subTypes;
                if (acceptHeader == null || !(acceptHeader = acceptHeader.trim()).startsWith(LE_MIME_TYPE)) continue;
                this.clientHasLiveEditInstalled = true;
                for (String subType : subTypes = acceptHeader.split(";")) {
                    int equalQuoteIndex = subType.indexOf("=\"");
                    String valueSubType = subType;
                    if (equalQuoteIndex >= 0 && subType.length() > equalQuoteIndex + 3) {
                        valueSubType = subType.substring(equalQuoteIndex + 2, subType.length() - 1);
                    }
                    this.advertizedLiveEditableMimeTypes.add(valueSubType.replace("!", "/"));
                }
            }
        }
    }

    public boolean isLiveEditInstalled() {
        if (this.clientHasLiveEditInstalled == null) {
            this.detectLiveEditClientConfig();
        }
        return this.clientHasLiveEditInstalled;
    }

    public String getLiveEditConfigurationPolicy() {
        if (liveEditConfigPolicy == null) {
            liveEditConfigPolicy = Framework.getProperty((String)LE_CONFIG_PROPERTY, (String)LE_CONFIG_CLIENTSIDE);
        }
        return liveEditConfigPolicy;
    }

    public boolean isMimeTypeLiveEditable(String mimetype) {
        if (this.advertizedLiveEditableMimeTypes == null) {
            this.detectLiveEditClientConfig();
        }
        return this.advertizedLiveEditableMimeTypes.contains(mimetype);
    }
}

