/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.jboss.seam.remoting.wrapper.Wrapper;
import org.jboss.seam.remoting.wrapper.WrapperFactory;

public class CallContext {
    private Map<String, Wrapper> inRefs = new HashMap<String, Wrapper>();
    private List<Wrapper> outRefs = new ArrayList<Wrapper>();

    public Wrapper createWrapperFromElement(Element element) {
        if ("ref".equals(element.getQualifiedName())) {
            if (this.inRefs.containsKey(element.attributeValue("id"))) {
                return this.inRefs.get(element.attributeValue("id"));
            }
            Element value = (Element)element.elements().get(0);
            Wrapper w = WrapperFactory.getInstance().createWrapper(value.getQualifiedName());
            w.setElement(value);
            w.setCallContext(this);
            this.inRefs.put(element.attributeValue("id"), w);
            return w;
        }
        Wrapper w = WrapperFactory.getInstance().createWrapper(element.getQualifiedName());
        w.setElement(element);
        w.setCallContext(this);
        return w;
    }

    public Wrapper createWrapperFromObject(Object value, String path) {
        for (Wrapper ref : this.outRefs) {
            if (!ref.getValue().equals(value)) continue;
            return ref;
        }
        Wrapper w = WrapperFactory.getInstance().getWrapperForObject(value);
        w.setCallContext(this);
        w.setPath(path);
        return w;
    }

    public Map<String, Wrapper> getInRefs() {
        return this.inRefs;
    }

    public List<Wrapper> getOutRefs() {
        return this.outRefs;
    }

    public void addOutRef(Wrapper w) {
        if (!this.outRefs.contains(w)) {
            this.outRefs.add(w);
        }
    }
}

