/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.resource.writer.impl;

import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;
import org.richfaces.util.StreamUtils;

final class ThroughputResourceProcessor
implements ResourceProcessor {
    public static final ResourceProcessor INSTANCE = new ThroughputResourceProcessor();

    private ThroughputResourceProcessor() {
    }

    @Override
    public boolean isSupportedFile(String name) {
        return true;
    }

    @Override
    public void process(String outputName, ByteSource byteSource, ByteSink byteSink, boolean closeAtFinish) throws IOException {
        this.process(outputName, byteSource.openStream(), byteSink.openStream(), closeAtFinish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String outputName, InputStream in, OutputStream out, boolean closeAtFinish) throws IOException {
        try {
            StreamUtils.copy(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            if (closeAtFinish) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            } else {
                out.flush();
            }
        }
    }
}

