/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth.webapp;

import java.io.Serializable;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

@Name(value="tokenAuthenticationActions")
@Scope(value=ScopeType.CONVERSATION)
public class TokenAuthenticationActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    private transient NuxeoPrincipal currentNuxeoPrincipal;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected DocumentModelList currentUserAuthTokenBindings;

    public DocumentModelList getCurrentUserAuthTokenBindings() {
        if (this.currentUserAuthTokenBindings == null) {
            TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
            this.currentUserAuthTokenBindings = tokenAuthenticationService.getTokenBindings(this.currentNuxeoPrincipal.getName());
        }
        return this.currentUserAuthTokenBindings;
    }

    public void deleteAuthTokenBinding(String tokenId) {
        TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
        tokenAuthenticationService.revokeToken(tokenId);
        this.reset();
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("label.tokenauth.revoked"), new Object[0]);
    }

    public void deleteAllTokenBindings() throws PropertyException {
        this.reset();
        TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
        for (DocumentModel tokenBinding : this.getCurrentUserAuthTokenBindings()) {
            String tokenId = (String)((Object)tokenBinding.getPropertyValue("authtoken:token"));
            tokenAuthenticationService.revokeToken(tokenId);
        }
        this.reset();
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("label.tokenauth.revoked"), new Object[0]);
    }

    public void refreshAuthTokenBindings() {
        this.reset();
    }

    protected void reset() {
        this.currentUserAuthTokenBindings = null;
    }
}

