/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.seam.annotations.In;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

public abstract class AbstractPublishActions {
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected Map<String, String> messages;

    public String getFormattedPath(DocumentModel documentModel) {
        ArrayList<String> pathFragments = new ArrayList<String>();
        this.getPathFragments(documentModel, pathFragments);
        return AbstractPublishActions.formatPathFragments(pathFragments);
    }

    protected static String formatPathFragments(List<String> pathFragments) {
        String fullPath = "";
        for (String aFragment : pathFragments) {
            if (!"".equals(fullPath)) {
                fullPath = ">" + fullPath;
            }
            fullPath = aFragment + fullPath;
        }
        return fullPath;
    }

    protected void getPathFragments(DocumentModel documentModel, List<String> pathFragments) {
        String pathElementName = documentModel.getTitle();
        String translatedPathElement = this.messages.get(pathElementName);
        pathFragments.add(translatedPathElement);
        if (this.isDomain(documentModel) || "/".equals(documentModel.getPathAsString())) {
            return;
        }
        DocumentModel parentDocument = this.getParentDocument(documentModel);
        if (parentDocument != null) {
            this.getPathFragments(parentDocument, pathFragments);
        }
    }

    protected DocumentModel getParentDocument(DocumentModel documentModel) {
        if (this.documentManager.hasPermission(documentModel.getParentRef(), "Read")) {
            return this.documentManager.getDocument(documentModel.getParentRef());
        }
        return null;
    }

    protected boolean isDomain(DocumentModel documentModel) {
        for (DocumentType type = documentModel.getDocumentType(); type != null; type = type.getSuperType()) {
            if (!"Domain".equals(type.getName())) continue;
            return true;
        }
        return false;
    }
}

