/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree.nav;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionPropertiesDescriptor;

@XObject(value="navTree")
public class NavTreeDescriptor
implements Serializable,
Comparable<NavTreeDescriptor> {
    public static final String ACTION_ID_PREFIX = "navtree_";
    private static final long serialVersionUID = 1L;
    @XNode(value="@treeId")
    private String treeId;
    @XNode(value="@treeLabel")
    private String treeLabel;
    @XNode(value="@xhtmlview")
    private String xhtmlview;
    @XNode(value="@directoryTreeBased")
    private boolean directoryTreeBased = false;
    @XNode(value="@order")
    private Integer order = 100;
    @XNode(value="@enabled")
    private boolean enabled = true;

    public boolean isDirectoryTreeBased() {
        return this.directoryTreeBased;
    }

    public void setDirectoryTreeBased(boolean directoryTreeBased) {
        this.directoryTreeBased = directoryTreeBased;
    }

    public String getXhtmlview() {
        return this.xhtmlview;
    }

    public void setXhtmlview(String xhtmlview) {
        this.xhtmlview = xhtmlview;
    }

    public NavTreeDescriptor() {
    }

    public NavTreeDescriptor(String treeId, String treeLabel) {
        this(treeId, treeLabel, false);
    }

    public NavTreeDescriptor(String treeId, String treeLabel, boolean directoryTreeBased) {
        this.treeId = treeId;
        this.treeLabel = treeLabel;
        this.directoryTreeBased = directoryTreeBased;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getTreeLabel() {
        return this.treeLabel;
    }

    public void setTreeLabel(String treeLabel) {
        this.treeLabel = treeLabel;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int compareTo(NavTreeDescriptor o) {
        return this.getOrder().compareTo(o.getOrder());
    }

    protected Action getAction() {
        Action a = new Action(ACTION_ID_PREFIX + this.getTreeId(), new String[]{"TREE_EXPLORER"});
        a.setType("rest_document_link");
        a.setLabel(this.getTreeLabel());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("ajaxSupport", "true");
        if (this.isDirectoryTreeBased()) {
            props.put("link", "/incl/single_directory_tree_explorer.xhtml");
        } else {
            props.put("link", this.getXhtmlview());
        }
        ActionPropertiesDescriptor pdesc = new ActionPropertiesDescriptor();
        pdesc.setProperties(props);
        a.setPropertiesDescriptor(pdesc);
        Integer order = this.getOrder();
        if (order != null) {
            a.setOrder(order.intValue());
        }
        a.setEnabled(this.isEnabled());
        a.setIcon(String.format("/img/%s.png", this.getTreeId()));
        a.setFilterIds(new ArrayList());
        return a;
    }
}

