/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.LinkedList;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.richfaces.component.AbstractTree;
import org.richfaces.component.AbstractTreeNode;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.model.TreeDataModelTuple;
import org.richfaces.model.TreeDataVisitor;
import org.richfaces.renderkit.TreeNodeRendererBase;
import org.richfaces.renderkit.TreeNodeState;

abstract class TreeEncoderBase
implements TreeDataVisitor {
    static final String TREE_NODE_STATE_ATTRIBUTE = "__treeNodeState";
    protected final FacesContext context;
    protected final ResponseWriter responseWriter;
    protected final AbstractTree tree;
    private LinkedList<QueuedData> queuedDataList = new LinkedList();

    public TreeEncoderBase(FacesContext context, AbstractTree tree) {
        this.context = context;
        this.responseWriter = context.getResponseWriter();
        this.tree = tree;
    }

    protected void encodeTree() throws IOException {
        this.tree.walkModel(this.context, this);
    }

    protected void flushParentNode() throws IOException {
        if (this.queuedDataList.isEmpty()) {
            return;
        }
        QueuedData data = this.queuedDataList.getLast();
        if (!data.isEncoded()) {
            data.makeEncoded();
            this.tree.restoreFromSnapshot(this.context, data.getTuple());
            TreeNodeState nodeState = this.getNodeState(this.tree.isLeaf(), false);
            this.writeTreeNodeStartElement(nodeState);
            this.tree.findTreeNodeComponent().encodeAll(this.context);
        }
    }

    private TreeNodeState getNodeState(boolean leaf, boolean visited) {
        TreeNodeState nodeState = leaf ? TreeNodeState.leaf : (visited ? TreeNodeState.expandedNoChildren : (this.tree.isExpanded() ? TreeNodeState.expanded : TreeNodeState.collapsed));
        return nodeState;
    }

    @Override
    public void beforeChildrenVisit() {
        if (!this.queuedDataList.isEmpty()) {
            this.queuedDataList.getLast().makeVisited();
        }
    }

    @Override
    public void afterChildrenVisit() {
    }

    @Override
    public void enterNode() {
        TreeDataModelTuple tuple = this.tree.createSnapshot();
        QueuedData queuedData = new QueuedData(tuple);
        try {
            this.flushParentNode();
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        this.tree.restoreFromSnapshot(this.context, tuple);
        this.queuedDataList.add(queuedData);
    }

    @Override
    public void exitNode() {
        QueuedData data = this.queuedDataList.removeLast();
        this.tree.restoreFromSnapshot(this.context, data.getTuple());
        try {
            if (!data.isEncoded()) {
                this.writeTreeNodeStartElement(this.getNodeState(this.tree.isLeaf(), data.isVisited()));
                this.tree.findTreeNodeComponent().encodeAll(this.context);
            }
            this.writeTreeNodeEndElement();
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeTreeNodeStartElement(TreeNodeState nodeState) throws IOException {
        AbstractTreeNode treeNodeComponent = this.tree.findTreeNodeComponent();
        this.context.getAttributes().put(TREE_NODE_STATE_ATTRIBUTE, nodeState);
        this.responseWriter.startElement("div", (UIComponent)this.tree);
        this.responseWriter.writeAttribute("class", (Object)HtmlUtil.concatClasses((Object[])new Object[]{"rf-tr-nd", nodeState.getNodeClass()}), null);
        this.responseWriter.writeAttribute("id", (Object)treeNodeComponent.getClientId(this.context), null);
        this.emitClientToggleEvent(treeNodeComponent, nodeState);
    }

    protected void writeTreeNodeEndElement() throws IOException {
        this.responseWriter.endElement("div");
    }

    public abstract void encode() throws IOException;

    private void emitClientToggleEvent(AbstractTreeNode treeNode, TreeNodeState nodeState) {
        TreeNodeState initialState;
        if (treeNode.getClientId(this.context).equals(this.context.getAttributes().get(TreeNodeRendererBase.AJAX_TOGGLED_NODE_ATTRIBUTE)) && (initialState = (TreeNodeState)((Object)this.context.getAttributes().get(TreeNodeRendererBase.AJAX_TOGGLED_NODE_STATE_ATTRIBUTE))).isDifferentThan(nodeState)) {
            ExtendedPartialViewContext partialContext = ExtendedPartialViewContext.getInstance((FacesContext)this.context);
            partialContext.appendOncomplete((Object)new JSFunction("RichFaces.ui.TreeNode.emitToggleEvent", new Object[]{treeNode.getClientId(this.context)}));
        }
    }

    private static final class QueuedData {
        private State state = State.initial;
        private TreeDataModelTuple tuple;

        public QueuedData(TreeDataModelTuple tuple) {
            this.tuple = tuple;
        }

        public boolean isEncoded() {
            return this.state == State.encoded;
        }

        public void makeEncoded() {
            this.state = State.encoded;
        }

        public void makeVisited() {
            this.state = State.visited;
        }

        public boolean isVisited() {
            return this.state == State.visited;
        }

        public TreeDataModelTuple getTuple() {
            return this.tuple;
        }

        private static enum State {
            initial,
            visited,
            encoded;

        }
    }
}

