/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.SimpleFileManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.util.FileUploadHelper;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

@Name(value="uploadRestlet")
@Scope(value=ScopeType.EVENT)
public class UploadRestlet
extends BaseNuxeoRestlet
implements Serializable {
    private static final Log log = LogFactory.getLog(UploadRestlet.class);
    private static final long serialVersionUID = -7858792615823015193L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected CoreSession documentManager;
    @In(create=true)
    protected transient SimpleFileManager FileManageActions;

    public void handle(Request req, Response res) {
        DocumentModel targetContainer;
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        String fileName = (String)req.getAttributes().get("filename");
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            targetContainer = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
        }
        catch (NuxeoException e) {
            UploadRestlet.handleError(res, (Exception)((Object)e));
            return;
        }
        if (targetContainer != null) {
            List<Blob> blobs = null;
            try {
                blobs = FileUploadHelper.parseRequest(req);
            }
            catch (IOException | FileUploadException e) {
                UploadRestlet.handleError(res, (Exception)e);
                return;
            }
            if (blobs == null) {
                String outcome;
                try {
                    Blob inputBlob;
                    try (InputStream in = req.getEntity().getStream();){
                        inputBlob = Blobs.createBlob((InputStream)in);
                    }
                    inputBlob.setFilename(fileName);
                    outcome = this.FileManageActions.addBinaryFileFromPlugin(inputBlob, fileName, targetContainer);
                }
                catch (IOException | NuxeoException e) {
                    outcome = "ERROR : " + e.getMessage();
                }
                result.addElement("upload").setText(outcome);
            } else {
                Element uploads = result.addElement("uploads");
                for (Blob blob : blobs) {
                    String outcome;
                    try {
                        outcome = this.FileManageActions.addBinaryFileFromPlugin(blob, blob.getFilename(), targetContainer);
                    }
                    catch (NuxeoException e) {
                        log.error((Object)("error importing " + blob.getFilename() + ": " + e.getMessage()), (Throwable)e);
                        outcome = "ERROR : " + e.getMessage();
                    }
                    uploads.addElement("upload").setText(outcome);
                }
            }
        }
        StringRepresentation rep = new StringRepresentation((CharSequence)result.asXML(), MediaType.APPLICATION_XML);
        rep.setCharacterSet(CharacterSet.UTF_8);
        res.setEntity((Representation)rep);
    }
}

