/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public final class BaseURL {
    private static final Log log = LogFactory.getLog(BaseURL.class);

    private BaseURL() {
    }

    static ServletRequest getRequest() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return null;
        }
        return (ServletRequest)facesContext.getExternalContext().getRequest();
    }

    public static String getServerURL() {
        return BaseURL.getServerURL(BaseURL.getRequest(), false);
    }

    public static String getServerURL(ServletRequest request, boolean local) {
        return VirtualHostHelper.getServerURL((ServletRequest)request, (boolean)local);
    }

    public static String getWebAppName() {
        ServletRequest request = BaseURL.getRequest();
        return VirtualHostHelper.getWebAppName((ServletRequest)request);
    }

    public static String getBaseURL() {
        return BaseURL.getBaseURL(BaseURL.getRequest());
    }

    public static String getBaseURL(ServletRequest request) {
        return VirtualHostHelper.getBaseURL((ServletRequest)request);
    }

    public static String getLocalBaseURL(ServletRequest request) {
        String localURL = null;
        String serverUrl = BaseURL.getServerURL(request, true);
        if (serverUrl != null) {
            localURL = serverUrl + BaseURL.getWebAppName() + '/';
        }
        if (localURL == null) {
            log.error((Object)"Could not retrieve local url correctly");
        }
        return localURL;
    }

    public static String getContextPath() {
        return VirtualHostHelper.getContextPath((ServletRequest)BaseURL.getRequest());
    }
}

