/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.ui;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.WorksheetItem;
import org.jboss.seam.excel.ui.UICellBase;
import org.jboss.seam.excel.ui.UIFormula;

public class UICell
extends UICellBase
implements WorksheetItem {
    public static final String COMPONENT_TYPE = "org.jboss.seam.excel.ui.UICell";
    private Object value;
    private Integer column;
    private Integer row;

    @Override
    public Integer getColumn() {
        return (Integer)this.valueOf("column", this.column);
    }

    public void setColumn(Integer column) {
        this.column = column;
    }

    @Override
    public Integer getRow() {
        return (Integer)this.valueOf("row", this.row);
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    @Override
    public Object getValue() {
        Object theValue = this.valueOf("value", this.value);
        if (theValue == null) {
            try {
                theValue = UICell.cmp2String(FacesContext.getCurrentInstance(), (UIComponent)this);
            }
            catch (IOException e) {
                String message = Interpolator.instance().interpolate("Could not render cell #0", new Object[]{this.getId()});
                throw new ExcelWorkbookException(message, e);
            }
        }
        return theValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public CellType getDataType() {
        if (this instanceof UIFormula) {
            return CellType.formula;
        }
        Object value = this.getValue();
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Short || value instanceof BigDecimal || value instanceof BigInteger || value instanceof Byte || value instanceof Float) {
            return CellType.number;
        }
        if (value instanceof String || value instanceof Character) {
            return CellType.text;
        }
        if (value instanceof java.util.Date || value instanceof Date) {
            return CellType.date;
        }
        if (value instanceof Boolean) {
            return CellType.bool;
        }
        return CellType.general;
    }

    @Override
    public WorksheetItem.ItemType getItemType() {
        return WorksheetItem.ItemType.cell;
    }

    public static enum CellType {
        general,
        number,
        text,
        date,
        formula,
        bool;

    }
}

