/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;

public class SelectItemComparator
implements Comparator<SelectItem>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] ordering;
    private final Boolean caseSensitive;
    private final Collator collator;
    private final Locale locale;

    public SelectItemComparator(String ordering, Boolean caseSentitive, Locale locale) {
        this.ordering = StringUtils.split((String)ordering, (String)",");
        this.caseSensitive = caseSentitive;
        if (locale == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.locale = context.getViewRoot().getLocale();
        } else {
            this.locale = locale;
        }
        this.collator = Collator.getInstance(this.locale);
        if (Boolean.TRUE.equals(this.caseSensitive)) {
            this.collator.setStrength(2);
        } else {
            this.collator.setStrength(1);
        }
    }

    public SelectItemComparator(String ordering, Boolean caseSensitive) {
        this(ordering, caseSensitive, null);
    }

    protected int compareField(String field, SelectItem item1, SelectItem item2) {
        if ("label".equals(field)) {
            String label1 = item1.getLabel();
            String label2 = item2.getLabel();
            return this.collator.compare(label1, label2);
        }
        if ("id".equals(field)) {
            String value1 = String.valueOf(item1.getValue());
            String value2 = String.valueOf(item2.getValue());
            return this.collator.compare(value1, value2);
        }
        throw new RuntimeException("Invalid sort criteria " + field);
    }

    @Override
    public int compare(SelectItem item1, SelectItem item2) {
        for (String field : this.ordering) {
            int compare = this.compareField(field, item1, item2);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

