/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.jboss.seam.web.MultipartRequest;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.restlet.data.Request;

public class FileUploadHelper {
    private FileUploadHelper() {
    }

    public static List<Blob> parseRequest(Request request) throws FileUploadException, IOException {
        HttpRequest httpRequest;
        HttpCall httpCall;
        if (request instanceof HttpRequest && (httpCall = (httpRequest = (HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            HttpServletRequest httpServletRequest = ((ServletCall)httpCall).getRequest();
            return FileUploadHelper.parseRequest(httpServletRequest);
        }
        return null;
    }

    public static List<Blob> parseRequest(HttpServletRequest request) throws FileUploadException, IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        if (request instanceof MultipartRequest) {
            MultipartRequest seamMPRequest = (MultipartRequest)request;
            Enumeration names = seamMPRequest.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                InputStream in = seamMPRequest.getFileInputStream(name);
                Throwable throwable = null;
                try {
                    if (in == null) continue;
                    Blob blob = Blobs.createBlob((InputStream)in);
                    blob.setFilename(seamMPRequest.getFileName(name));
                    blobs.add(blob);
                }
                catch (Throwable blob) {
                    throwable = blob;
                    throw blob;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable blob) {
                            throwable.addSuppressed(blob);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        } else {
            FileUpload fu = new FileUpload((FileItemFactory)new DiskFileItemFactory());
            String fileNameCharset = request.getHeader("FileNameCharset");
            if (fileNameCharset != null) {
                fu.setHeaderEncoding(fileNameCharset);
            }
            ServletRequestContext requestContext = new ServletRequestContext(request);
            List fileItems = fu.parseRequest((RequestContext)requestContext);
            for (FileItem item : fileItems) {
                InputStream is = item.getInputStream();
                Throwable throwable = null;
                try {
                    Blob blob = Blobs.createBlob((InputStream)is);
                    blob.setFilename(item.getName());
                    blobs.add(blob);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        return blobs;
    }
}

