/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.userworkspace.web.ejb;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="userWorkspaceChecker")
public class UserWorkspaceCheckerActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(required=false, create=true)
    protected transient CoreSession documentManager;
    protected Boolean isUserWorkspace;
    protected String currentPersonalWorkspacePath;

    @Factory(value="isUserWorkspace", scope=ScopeType.EVENT)
    public Boolean computeIsUserWorkspace() {
        if (this.isUserWorkspace == null && this.navigationContext.getCurrentDocument() != null) {
            this.isUserWorkspace = this.navigationContext.getCurrentDocument().getPathAsString().contains("UserWorkspaces");
        }
        return this.isUserWorkspace;
    }

    @Factory(value="currentPersonalWorkspacePath", scope=ScopeType.EVENT)
    public String getCurrentPersonalWorkspace() {
        if (this.currentPersonalWorkspacePath == null && Boolean.TRUE.equals(this.isUserWorkspace)) {
            Path path = this.navigationContext.getCurrentDocument().getPath();
            String lastSegment = "";
            while (!path.isRoot() || !path.isEmpty()) {
                if ("UserWorkspaces".equals(path.lastSegment())) {
                    this.currentPersonalWorkspacePath = lastSegment.isEmpty() ? "" : path.append(lastSegment).toString();
                    return this.currentPersonalWorkspacePath;
                }
                lastSegment = path.lastSegment();
                path = path.removeLastSegments(1);
            }
        }
        return this.currentPersonalWorkspacePath;
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged", "locationSelectionChanged"}, create=false)
    @BypassInterceptors
    public void reset() {
        this.isUserWorkspace = null;
        this.currentPersonalWorkspacePath = null;
    }
}

