/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.localconf;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.theme.localconfiguration.LocalThemeConfig;
import org.nuxeo.theme.localconfiguration.LocalThemeHelper;
import org.nuxeo.theme.styling.service.ThemeStylingService;
import org.nuxeo.theme.styling.service.descriptors.FlavorDescriptor;

@Name(value="themeConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class ThemeConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient ThemeStylingService themeStylingService;
    protected String theme;

    public String getConfigurationLayout() {
        return "theme_configuration";
    }

    public List<FlavorDescriptor> getAvailableFlavors(String themePage) {
        return this.themeStylingService.getFlavors(themePage);
    }

    public String getDefaultFlavorName(String themePage) {
        return this.themeStylingService.getDefaultFlavorName(themePage);
    }

    public FlavorDescriptor getDefaultFlavor(String themePage) {
        String flavorName = this.themeStylingService.getDefaultFlavorName(themePage);
        if (flavorName != null) {
            return this.themeStylingService.getFlavor(flavorName);
        }
        return null;
    }

    public String getCurrentLocalFlavorName() {
        LocalThemeConfig localThemeConfig;
        DocumentModel currentSuperSpace = this.navigationContext.getCurrentSuperSpace();
        if (currentSuperSpace != null && (localThemeConfig = LocalThemeHelper.getLocalThemeConfig((DocumentModel)currentSuperSpace)) != null) {
            String flavor = localThemeConfig.getFlavor();
            return flavor;
        }
        return null;
    }
}

