/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.dm.operation;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.dm.adapter.TaskStep;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Deprecated
@Operation(id="Workflow.CreateRoutingTask", category="Services", label="Create task", since="5.6", description="Enable to create a routingTask bound to a route and its document. In <b>accept operation chain</b> and <b>reject operation chain</b> fields, you can put the operation chain ID of your choice among the one you contributed. Those operations will be executed when the user validates the task, depending on  whether he accepts or rejects the task. Extra (String) properties can be set on the taskVariables from the input document or from the step.", addToStudio=false)
public class CreateRoutingTask {
    public static final String ID = "Workflow.CreateRoutingTask";
    private static final Log log = LogFactory.getLog(CreateRoutingTask.class);
    public static final String STEP_PREFIX = "StepTask:";
    public static final String DOCUMENT_PREFIX = "Document:";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession coreSession;
    @Context
    UserManager userManager;
    @Context
    protected TaskService taskService;
    @Context
    protected DocumentRoutingService routing;
    @Param(name="accept operation chain", required=false, order=4)
    protected String acceptOperationChain;
    @Param(name="reject operation chain", required=false, order=5)
    protected String rejectOperationChain;
    @Param(name="mappingTaskVariables", required=false)
    protected Properties mappingTaskVariables;
    @Param(name="mappingProperties", required=false)
    protected Properties mappingProperties;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel createTask(DocumentModel document) throws OperationException {
        Principal pal = this.coreSession.getPrincipal();
        if (!(pal instanceof NuxeoPrincipal)) {
            throw new OperationException("Principal is not an instance of NuxeoPrincipal");
        }
        DocumentRouteStep step = (DocumentRouteStep)this.ctx.get((Object)"document.routing.step");
        DocumentModel stepDocument = step.getDocument();
        TaskStep taskStep = (TaskStep)stepDocument.getAdapter(TaskStep.class);
        List<String> actors = taskStep.getActors();
        if (actors.isEmpty()) {
            log.debug((Object)"No actors could be resolved => do not create any task");
            return document;
        }
        HashMap<String, String> taskVariables = new HashMap<String, String>();
        taskVariables.put("document.routing.step", step.getDocument().getId());
        taskVariables.put(OperationTaskVariableName.createdFromCreateTaskOperation.name(), "true");
        if (!StringUtils.isEmpty((String)this.acceptOperationChain)) {
            taskVariables.put(OperationTaskVariableName.acceptOperationChain.name(), this.acceptOperationChain);
        }
        if (!StringUtils.isEmpty((String)this.rejectOperationChain)) {
            taskVariables.put(OperationTaskVariableName.rejectOperationChain.name(), this.rejectOperationChain);
        }
        taskVariables.put("disableNotificationService", "true");
        if (this.routing == null) {
            throw new OperationException("Service routingTaskService not found");
        }
        if (this.mappingTaskVariables != null) {
            this.mapPropertiesToTaskVariables(taskVariables, stepDocument, document, this.mappingTaskVariables);
        }
        List tasks = this.taskService.createTask(this.coreSession, (NuxeoPrincipal)pal, document, taskStep.getName(), actors, false, taskStep.getDirective(), null, taskStep.getDueDate(), taskVariables, null);
        this.routing.makeRoutingTasks(this.coreSession, tasks);
        DocumentModelListImpl docList = new DocumentModelListImpl(tasks.size());
        for (Task task : tasks) {
            docList.add((Object)(this.mappingProperties == null ? task.getDocument() : this.mapPropertiesToTaskDocument(this.coreSession, stepDocument, task.getDocument(), document, this.mappingProperties)));
        }
        for (String actor : actors) {
            step.setCanReadStep(this.coreSession, actor);
            step.setCanValidateStep(this.coreSession, actor);
            step.setCanUpdateStep(this.coreSession, actor);
        }
        this.ctx.put(OperationTaskVariableName.taskDocuments.name(), (Object)docList);
        this.ctx.put("document.routing.task.actors", (Object)new StringList(this.getAllActors(actors)));
        return document;
    }

    protected void mapPropertiesToTaskVariables(Map<String, String> taskVariables, DocumentModel stepDoc, DocumentModel inputDoc, Properties mappingProperties) {
        for (Map.Entry prop : mappingProperties.entrySet()) {
            String getter = (String)prop.getKey();
            String setter = (String)prop.getValue();
            DocumentModel setterDoc = null;
            if (setter.startsWith(DOCUMENT_PREFIX)) {
                setterDoc = inputDoc;
                setter = setter.substring(DOCUMENT_PREFIX.length());
            } else if (setter.startsWith(STEP_PREFIX)) {
                setterDoc = stepDoc;
                setter = setter.substring(STEP_PREFIX.length());
            }
            try {
                taskVariables.put(getter, (String)((Object)setterDoc.getPropertyValue(setter)));
            }
            catch (PropertyException e) {
                log.error((Object)"Could not map property on the task document in the taskVariables ", (Throwable)e);
            }
        }
    }

    DocumentModel mapPropertiesToTaskDocument(CoreSession session, DocumentModel stepDoc, DocumentModel taskDoc, DocumentModel inputDoc, Properties mappingProperties) {
        for (Map.Entry prop : mappingProperties.entrySet()) {
            String getter = (String)prop.getKey();
            String setter = (String)prop.getValue();
            DocumentModel setterDoc = null;
            if (setter.startsWith(DOCUMENT_PREFIX)) {
                setterDoc = inputDoc;
                setter = setter.substring(DOCUMENT_PREFIX.length());
            } else if (setter.startsWith(STEP_PREFIX)) {
                setterDoc = stepDoc;
                setter = setter.substring(STEP_PREFIX.length());
            }
            try {
                taskDoc.setPropertyValue(getter, setterDoc.getPropertyValue(setter));
            }
            catch (PropertyException e) {
                log.error((Object)"Could not map property on the task document in the taskVariables ", (Throwable)e);
            }
        }
        return session.saveDocument(taskDoc);
    }

    protected List<String> getAllActors(List<String> actors) {
        ArrayList<String> allActors = new ArrayList<String>();
        for (String actor : actors) {
            if (this.userManager.getGroup(actor) != null) {
                List allSimpleUsers = this.userManager.getUsersInGroupAndSubGroups(actor);
                for (String string : allSimpleUsers) {
                    if (allActors.contains(string)) continue;
                    allActors.add(string);
                }
                continue;
            }
            if (allActors.contains(actor)) continue;
            allActors.add(actor);
        }
        return allActors;
    }

    public static enum OperationTaskVariableName {
        acceptOperationChain,
        rejectOperationChain,
        createdFromCreateTaskOperation,
        taskDocuments;

    }
}

