/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.seam;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocListener;
import com.lowagie.text.Image;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.html.simpleparser.ImageProvider;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public class NuxeoITextImageProvider
implements ImageProvider {
    protected final HttpServletRequest request;

    public NuxeoITextImageProvider(HttpServletRequest request) {
        this.request = request;
    }

    public Image getImage(String src, HashMap h, ChainedProperties cprops, DocListener doc) {
        String uriPath;
        URI uri;
        String uriQuery;
        if (!src.startsWith("http")) {
            String base = VirtualHostHelper.getServerURL((ServletRequest)this.request, (boolean)false);
            if (base != null && base.endsWith("/")) {
                base = base.substring(0, base.length() - 1);
            }
            if (base != null) {
                src = base + src;
            }
        }
        if ((uriQuery = (uri = URI.create(src = (uriPath = URIUtils.getURIPath((String)src)) + ";jsessionid=" + DocumentModelFunctions.extractJSessionId(this.request))).getQuery()) != null && uriQuery.length() > 0) {
            src = src + '?' + uriQuery;
        }
        try {
            return Image.getInstance((String)src);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (BadElementException e) {
            throw new RuntimeException(e);
        }
    }
}

