/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.richfaces.javascript.LibraryScriptString;

public class LibraryResource {
    private final String library;
    private final String resourceName;

    public LibraryResource(String library, String resourceName) {
        this.library = library;
        this.resourceName = resourceName;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.library == null ? 0 : this.library.hashCode());
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LibraryResource other = (LibraryResource)obj;
        if (this.library == null ? other.library != null : !this.library.equals(other.library)) {
            return false;
        }
        return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
    }

    public String toString() {
        return this.getLibrary() + ':' + this.getResourceName();
    }

    public static Iterable<LibraryResource> of(Iterable<LibraryScriptString> scripts) {
        LinkedHashSet resources = Sets.newLinkedHashSet();
        for (LibraryScriptString scriptString : scripts) {
            resources.add(scriptString.getResource());
        }
        return resources;
    }
}

