/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.core.datamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.w3c.dom.Element;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ValidationException;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBaseObject
implements Serializable {
    protected String _base;
    protected String _lang;
    protected String _resource;
    protected String _about;
    protected Map<QName, String> _otherAttributes = new HashMap<QName, String>(0);
    protected List<Element> _otherElements = new ArrayList<Element>(0);

    AbstractBaseObject() {
    }

    public String getBase() {
        return this._base;
    }

    public String getLang() {
        return this._lang;
    }

    public Locale getLangAsLocale() {
        if (this._lang == null) {
            return null;
        }
        return new Locale(this._lang);
    }

    public String getResource() {
        return this._resource;
    }

    public String getAbout() {
        return this._about;
    }

    public List<Element> getOtherElements() {
        return this._otherElements;
    }

    public Element getElementByNS(String namespaceURI, String localName) {
        return XMLUtils.getElementByNS(this._otherElements, namespaceURI, localName);
    }

    public Element getElementByLocalName(String localName) {
        return XMLUtils.getElementByLocalName(this._otherElements, localName);
    }

    public Map<QName, String> getOtherAttributes() {
        return this._otherAttributes;
    }

    public String getAttributeValueByLocalName(String localName) {
        if (this._otherAttributes != null && localName != null) {
            for (Map.Entry<QName, String> e : this._otherAttributes.entrySet()) {
                if (!localName.equals(e.getKey().getLocalPart())) continue;
                return e.getValue();
            }
        }
        return null;
    }

    public String getAttributeValueByQName(QName name) {
        if (this._otherAttributes != null) {
            return this._otherAttributes.get(name);
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public abstract void validate(FeedFormat var1) throws ValidationException;
}

