/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.email;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.Renderer;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.email.EmailSenderActions;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;

@Name(value="emailSenderAction")
@Scope(value=ScopeType.STATELESS)
public class EmailSenderActionsBean
extends InputController
implements EmailSenderActions {
    private static final Log log = LogFactory.getLog(EmailSenderActionsBean.class);
    @In(create=true)
    UserManager userManager;
    @In(create=true, required=false)
    CoreSession documentManager;
    @In(create=true)
    private Renderer renderer;
    @In(required=false)
    @Out(required=false)
    private String mailSubject;
    @In(required=false)
    @Out(required=false)
    private String mailContent;
    @In(required=false)
    @Out(required=false)
    private String currentDocumentFullUrl;
    @In(create=true)
    @Out
    private PrincipalListManager principalListManager;
    @Out(required=false)
    private String fromEmail;
    @Out(required=false)
    private List<NuxeoPrincipal> toEmail;

    @Override
    public void send() {
        if (this.mailSubject == null || this.mailSubject.trim().length() == 0) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.email.subject.empty"), new Object[0]);
            return;
        }
        if (this.principalListManager.getSelectedUserListEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.email.nousers.selected"), new Object[0]);
        } else {
            NuxeoPrincipal currentUser = (NuxeoPrincipal)FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
            this.fromEmail = currentUser.getEmail();
            ArrayList<NuxeoPrincipal> listEmails = new ArrayList<NuxeoPrincipal>();
            for (String user : this.principalListManager.getSelectedUsers()) {
                NuxeoPrincipal principal = this.userManager.getPrincipal(user);
                listEmails.add(principal);
            }
            this.toEmail = listEmails;
            this.currentDocumentFullUrl = DocumentModelFunctions.documentUrl((DocumentModel)this.navigationContext.getCurrentDocument());
            log.debug((Object)("URL : " + DocumentModelFunctions.documentUrl((DocumentModel)this.navigationContext.getCurrentDocument())));
            try {
                log.debug((Object)("Subject : " + this.mailSubject));
                log.debug((Object)("Content : " + this.mailContent));
                this.renderer.render("/mail_template.xhtml");
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.email.send.ok"), new Object[0]);
            }
            catch (RuntimeException e) {
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.email.send.failed"), new Object[0]);
                log.error((Object)("Email sending failed:" + e.getMessage()));
            }
        }
    }

    @Override
    public String getMailContent() {
        return this.mailContent;
    }

    @Override
    public void setMailContent(String mailContent) {
        this.mailContent = mailContent;
    }

    @Override
    public String getMailSubject() {
        return this.mailSubject;
    }

    @Override
    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public PrincipalListManager getPrincipalListManager() {
        return this.principalListManager;
    }

    public void setPrincipalListManager(PrincipalListManager principalListManager) {
        this.principalListManager = principalListManager;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public List<NuxeoPrincipal> getToEmail() {
        return this.toEmail;
    }

    public void setToEmail(List<NuxeoPrincipal> toEmail) {
        this.toEmail = toEmail;
    }

    public String getCurrentDocumentFullUrl() {
        return this.currentDocumentFullUrl;
    }

    public void setCurrentDocumentFullUrl(String currentDocumentFullUrl) {
        this.currentDocumentFullUrl = currentDocumentFullUrl;
    }
}

