/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.validator.Min;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinValidator
implements Validator<Min>,
PropertyConstraint,
Serializable {
    private long min;

    @Override
    public void initialize(Min parameters) {
        this.min = parameters.value();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value).compareTo(BigDecimal.valueOf(this.min)) >= 0;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (value instanceof Double || value instanceof Float) {
            double dv = ((Number)value).doubleValue();
            return dv >= (double)this.min;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(this.min)) >= 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(this.min)) >= 0;
        }
        if (value instanceof Number) {
            long lv = ((Number)value).longValue();
            return lv >= this.min;
        }
        return false;
    }

    @Override
    public void apply(Property property) {
        Column col = (Column)property.getColumnIterator().next();
        col.setCheckConstraint(col.getName() + ">=" + this.min);
    }
}

