/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.binding.alias;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.el.ValueExpressionLiteral;

public class AliasVariableMapperWrapper
extends VariableMapper {
    private static final Log log = LogFactory.getLog(AliasVariableMapperWrapper.class);
    protected final VariableMapper orig;
    protected final List<String> blockedPatterns;
    protected Map vars;

    public AliasVariableMapperWrapper(VariableMapper orig, List<String> blockedPatterns) {
        this.orig = orig;
        this.blockedPatterns = blockedPatterns;
    }

    public ValueExpression resolveVariable(String variable) {
        ValueExpression ve = null;
        try {
            if (this.vars != null) {
                ve = (ValueExpression)this.vars.get(variable);
            }
            if (ve == null) {
                if (variable != null && this.blockedPatterns != null) {
                    for (String blockedPattern : this.blockedPatterns) {
                        if (blockedPattern == null) continue;
                        boolean doBlock = false;
                        if (blockedPattern.endsWith("*")) {
                            String pattern = blockedPattern.substring(0, blockedPattern.length() - 1);
                            if (variable.startsWith(pattern)) {
                                doBlock = true;
                            }
                        } else if (blockedPattern.equals(variable)) {
                            doBlock = true;
                        }
                        if (!doBlock) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Blocked expression var='" + variable + "'"));
                        }
                        return this.getNullValueExpression();
                    }
                }
                return this.orig.resolveVariable(variable);
            }
            return ve;
        }
        catch (StackOverflowError e) {
            throw new ELException("Could not Resolve Variable [Overflow]: " + variable, (Throwable)e);
        }
    }

    protected ValueExpression getNullValueExpression() {
        return new ValueExpressionLiteral(null, Object.class);
    }

    public ValueExpression setVariable(String variable, ValueExpression expression) {
        if (this.vars == null) {
            this.vars = new HashMap();
        }
        return this.vars.put(variable, expression);
    }
}

