/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.jboss.seam.remoting.messaging.SubscriptionRegistry;

public class RemoteSubscriber {
    private String token;
    private String topicName;
    private Topic topic;
    private TopicSession topicSession;
    private TopicSubscriber subscriber;

    public RemoteSubscriber(String token, String topicName) {
        this.token = token;
        this.topicName = topicName;
    }

    public String getToken() {
        return this.token;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void subscribe(TopicConnection conn) throws JMSException {
        this.topicSession = conn.createTopicSession(false, 1);
        this.topic = this.topicSession.createTopic(this.topicName);
        this.subscriber = this.topicSession.createSubscriber(this.topic);
    }

    public void unsubscribe() {
        try {
            this.subscriber.close();
            SubscriptionRegistry.instance().getUserTokens().remove(this.token);
        }
        catch (JMSException ex) {
            // empty catch block
        }
        try {
            this.topicSession.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void setTopicSubscriber(TopicSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public TopicSubscriber getTopicSubscriber() {
        return this.subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> poll(int timeout) throws JMSException {
        ArrayList<Message> messages = null;
        Message m = null;
        TopicSubscriber topicSubscriber = this.subscriber;
        synchronized (topicSubscriber) {
            do {
                if ((m = messages == null && timeout > 0 ? this.subscriber.receive((long)(timeout * 1000)) : this.subscriber.receiveNoWait()) == null) continue;
                if (messages == null) {
                    messages = new ArrayList<Message>();
                }
                messages.add(m);
            } while (m != null);
        }
        return messages;
    }
}

