/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.ui.web.binding.BlockingVariableMapper;
import org.nuxeo.ecm.platform.ui.web.binding.MetaValueExpression;

public class LayoutRowTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutRowTagHandler.class);
    protected final TagConfig config;

    public LayoutRowTagHandler(TagConfig config) {
        super(config);
        this.config = config;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        FaceletHandlerHelper helper = new FaceletHandlerHelper(this.config);
        if (FaceletHandlerHelper.isAliasOptimEnabled()) {
            this.applyOptimized(ctx, parent, helper);
        } else {
            this.applyCompat(ctx, parent, helper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyOptimized(FaceletContext ctx, UIComponent parent, FaceletHandlerHelper helper) throws IOException, FacesException, ELException {
        String rowCountVarName = RenderVariables.layoutVariables.layoutRowCount.name();
        TagAttribute rowCountAttr = helper.createAttribute(rowCountVarName, "#{" + rowCountVarName + "}");
        int rowCount = rowCountAttr.getInt(ctx);
        if (rowCount == 0) {
            return;
        }
        VariableMapper orig = ctx.getVariableMapper();
        try {
            for (int i = 0; i < rowCount; ++i) {
                BlockingVariableMapper vm = new BlockingVariableMapper(orig);
                ctx.setVariableMapper((VariableMapper)vm);
                ExpressionFactory eFactory = ctx.getExpressionFactory();
                ValueExpression ve = eFactory.createValueExpression((Object)("#{" + RenderVariables.layoutVariables.layout.name() + ".rows[" + i + "]}"), String.class);
                MetaValueExpression rowVe = new MetaValueExpression(ve, ctx.getFunctionMapper(), (VariableMapper)vm, LayoutRow.class);
                ValueExpression rowIndexVe = eFactory.createValueExpression((Object)i, Integer.class);
                String instanceName = this.getInstanceName();
                String indexName = this.getIndexName();
                vm.setVariable(instanceName, (ValueExpression)rowVe);
                vm.addBlockedPattern(instanceName);
                vm.setVariable(indexName, rowIndexVe);
                vm.addBlockedPattern(indexName);
                this.nextHandler.apply(ctx, parent);
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    protected void applyCompat(FaceletContext ctx, UIComponent parent, FaceletHandlerHelper helper) throws IOException, FacesException, ELException {
        Layout layout = null;
        String layoutVariableName = RenderVariables.layoutVariables.layout.name();
        TagAttribute layoutAttribute = helper.createAttribute(layoutVariableName, "#{" + layoutVariableName + "}");
        if (layoutAttribute != null) {
            layout = (Layout)layoutAttribute.getObject(ctx, Layout.class);
        }
        if (layout == null) {
            log.error((Object)("Could not resolve layout " + layoutAttribute));
            return;
        }
        LayoutRow[] rows = layout.getRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        int rowCounter = 0;
        for (LayoutRow row : rows) {
            HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
            ValueExpression rowVe = ctx.getExpressionFactory().createValueExpression((Object)row, LayoutRow.class);
            variables.put(RenderVariables.rowVariables.layoutRow.name(), rowVe);
            variables.put(RenderVariables.columnVariables.layoutColumn.name(), rowVe);
            ValueExpression rowIndexVe = ctx.getExpressionFactory().createValueExpression((Object)rowCounter, Integer.class);
            variables.put(RenderVariables.rowVariables.layoutRowIndex.name(), rowIndexVe);
            variables.put(RenderVariables.columnVariables.layoutColumnIndex.name(), rowIndexVe);
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.rowVariables.layoutRow.name());
            blockedPatterns.add(RenderVariables.rowVariables.layoutRowIndex.name());
            blockedPatterns.add(RenderVariables.columnVariables.layoutColumn.name());
            blockedPatterns.add(RenderVariables.columnVariables.layoutColumnIndex.name());
            FaceletHandler handler = helper.getAliasFaceletHandler(row.getTagConfigId(), variables, blockedPatterns, this.nextHandler);
            handler.apply(ctx, parent);
            ++rowCounter;
        }
    }

    protected String getInstanceName() {
        return RenderVariables.rowVariables.layoutRow.name();
    }

    protected String getIndexName() {
        return RenderVariables.rowVariables.layoutRowIndex.name();
    }
}

