/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.repo;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.ecm.admin.repo.RepoStatInfo;
import org.nuxeo.ecm.admin.repo.StatsTask;
import org.nuxeo.ecm.core.api.DocumentRef;

public class RepoStat {
    protected final ThreadPoolExecutor pool;
    protected int nbThreads = 5;
    protected final String repoName;
    protected final boolean includeBlob;
    protected RepoStatInfo info;

    public RepoStat(String repoName, int nbThreads, boolean includeBlob) {
        this.nbThreads = nbThreads;
        this.repoName = repoName;
        this.includeBlob = includeBlob;
        this.pool = new ThreadPoolExecutor(nbThreads, nbThreads, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new DaemonThreadFactory());
    }

    public void exec(StatsTask task) {
        this.pool.execute(task);
    }

    public void run(DocumentRef root) {
        this.info = new RepoStatInfo();
        StatsTask task = new StatsTask(this.repoName, root, this.includeBlob, this);
        this.exec(task);
    }

    protected boolean isPoolFull() {
        return this.pool.getQueue().size() > 1;
    }

    public RepoStatInfo getInfo() {
        return this.info;
    }

    public boolean isRunning() {
        return this.pool.getActiveCount() > 0;
    }

    protected static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final String namePrefix;
        private static final AtomicInteger poolNumber = new AtomicInteger();
        private final AtomicInteger threadNumber = new AtomicInteger();

        public DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "RepoStatThread-" + poolNumber.incrementAndGet() + '-';
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.namePrefix + this.threadNumber.incrementAndGet();
            Thread t = new Thread(this.group, r, name);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

