/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import com.sun.faces.util.MessageFactory;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileChoice;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;

public class InputFileSizeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "InputFileSizeValidator";
    private static final Log log = LogFactory.getLog(InputFileSizeValidator.class);
    private String maxSize = null;
    private boolean maximumSet = false;
    private boolean transientValue = false;
    public static final String MAXIMUM_MESSAGE_ID = "error.inputFile.maxSize";

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (!this.maximumSet) {
            return;
        }
        if (context == null || component == null) {
            throw new IllegalArgumentException();
        }
        if (value != null && value instanceof InputFileInfo) {
            InputFileInfo info = (InputFileInfo)value;
            String choice = info.getConvertedChoice();
            if (!InputFileChoice.isUploadOrKeepTemp(choice)) {
                return;
            }
            Blob blob = info.getConvertedBlob();
            long finalMaxSize = 0L;
            String maxString = null;
            if (this.maxSize != null) {
                finalMaxSize = this.getMaxSizeBytes();
                maxString = this.maxSize;
            }
            if (finalMaxSize != 0L && blob.getLength() > finalMaxSize) {
                throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)MAXIMUM_MESSAGE_ID, (Object[])new Object[]{maxString}));
            }
        }
    }

    private static long parseMaxSizeString(String maxSize) {
        long res = 0L;
        if (maxSize != null) {
            Integer maxSizeInt;
            if ((maxSize = maxSize.trim()).length() < 2) {
                log.error((Object)("Invalid maximum size " + maxSize));
                return res;
            }
            String suffix = maxSize.substring(maxSize.length() - 2);
            String maxSizeIntStr = maxSize.substring(0, maxSize.length() - 2).trim();
            try {
                maxSizeInt = Integer.valueOf(maxSizeIntStr);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid maximum size " + maxSize));
                return res;
            }
            if ("Ko".equals(suffix)) {
                res = maxSizeInt * 1000;
            } else if ("Mo".equals(suffix)) {
                res = maxSizeInt * 1000 * 1000;
            } else if (maxSize.endsWith("Go")) {
                res = maxSizeInt * 1000 * 1000 * 1000;
            } else {
                log.error((Object)("Invalid maximum size " + maxSize));
            }
        }
        return res;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    public long getMaxSizeBytes() {
        return InputFileSizeValidator.parseMaxSizeString(this.maxSize);
    }

    public void setMaxSize(String maxSizeString) {
        this.maxSize = maxSizeString;
        this.maximumSet = true;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maxSize, this.maximumSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maxSize = (String)values[0];
        this.maximumSet = (Boolean)values[1];
    }
}

