/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelect;
import org.nuxeo.ecm.platform.ui.web.directory.Selection;

public class ChainSelectStatus
extends UIOutput {
    public static final String COMPONENT_TYPE = "nxdirectory.chainSelectStatus";
    public static final String COMPONENT_FAMILY = "nxdirectory.chainSelectStatus";
    public static final String REMOVE_ID = "chainSelect_removeId";
    private static final Log log = LogFactory.getLog(ChainSelectStatus.class);
    private String name;
    private boolean displayIncremental = false;
    private boolean displayRoot = false;
    private String cssStyle;
    private String cssStyleClass;
    private String entryCssStyle;
    private String entryCssStyleClass;
    private String entrySeparator;
    private String image;
    private String display;
    private String label;

    public String getEntrySeparator() {
        return this.entrySeparator;
    }

    public void setEntrySeparator(String entrySeparator) {
        this.entrySeparator = entrySeparator;
    }

    public String getFamily() {
        return "nxdirectory.chainSelectStatus";
    }

    public String getRendererType() {
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.name = (String)values[1];
        this.displayIncremental = (Boolean)values[2];
        this.displayRoot = (Boolean)values[3];
        this.cssStyle = (String)values[4];
        this.cssStyleClass = (String)values[5];
        this.entryCssStyle = (String)values[6];
        this.entryCssStyleClass = (String)values[7];
        this.entrySeparator = (String)values[8];
        this.display = (String)values[9];
        this.image = (String)values[10];
        this.label = (String)values[11];
    }

    public Object saveState(FacesContext arg0) {
        Object[] values = new Object[]{super.saveState(arg0), this.name, this.displayIncremental, this.displayRoot, this.cssStyle, this.cssStyleClass, this.entryCssStyle, this.entryCssStyleClass, this.entrySeparator, this.display, this.image, this.label};
        return values;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = this.getClientId(context);
        String cssStyle = this.getStringProperty("cssStyle", null);
        String cssStyleClass = this.getStringProperty("cssStyleClass", null);
        String separator = this.getStringProperty("separator", "/");
        String entrySeparator = this.getStringProperty("entrySeparator", null);
        String label = this.getStringProperty("label", null);
        ChainSelect chain = this.getChain();
        Boolean displayValueOnly = chain.getBooleanProperty("displayValueOnly", false);
        String display = this.getStringProperty("display", "selection");
        Selection[] selections = display.equals("selection") ? chain.getSelections() : chain.getComponentValue();
        boolean multiParentSelect = chain.getBooleanProperty("multiParentSelect", false);
        if (displayValueOnly.booleanValue()) {
            cssStyle = chain.getStringProperty("displayValueOnlyStyle", null);
            cssStyleClass = chain.getStringProperty("displayValueOnlyStyleClass", null);
        }
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)id, "id");
        if (cssStyle != null) {
            writer.writeAttribute("style", (Object)cssStyle, "style");
        }
        if (cssStyleClass != null) {
            writer.writeAttribute("class", (Object)cssStyleClass, "class");
        }
        if (selections.length > 0 && label != null) {
            writer.write(label);
        }
        for (int i = 0; i < selections.length; ++i) {
            String concatenatedLabel;
            writer.startElement("div", (UIComponent)this);
            if (this.entryCssStyle != null) {
                writer.writeAttribute("style", (Object)this.entryCssStyle, "style");
            }
            if (this.entryCssStyleClass != null) {
                writer.writeAttribute("class", (Object)this.entryCssStyle, "class");
            }
            if (!displayValueOnly.booleanValue() && display.equals("value") && multiParentSelect) {
                UICommand button = (UICommand)this.getFacet("removeButton");
                if (button == null) {
                    throw new RuntimeException("f:facet with name='removeButton' not found for component " + this.getId());
                }
                String selectionId = selections[i].getValue(chain.getKeySeparator());
                this.getUIParameter((UIComponent)button).setValue((Object)selectionId);
                button.encodeBegin(context);
                button.encodeChildren(context);
                button.encodeEnd(context);
            }
            String[] labels = selections[i].getLabels();
            String[] values = selections[i].getValues();
            String[] displayedLabels = null;
            if (labels != null) {
                displayedLabels = new String[labels.length];
                for (int j = 0; j < labels.length; ++j) {
                    String compDisplay;
                    boolean localize;
                    if (chain.compInfos.get(i) != null) {
                        localize = chain.compInfos.get((Object)Integer.valueOf((int)i)).localize;
                        compDisplay = chain.compInfos.get((Object)Integer.valueOf((int)i)).display;
                    } else {
                        localize = chain.getComponent(j).getBooleanProperty("localize", false);
                        compDisplay = chain.getComponent(j).getDisplay();
                    }
                    String compLabel = labels[j];
                    if (localize) {
                        compLabel = ChainSelectStatus.translate(context, compLabel);
                    }
                    displayedLabels[j] = "id".equals(compDisplay) ? values[j] : ("idAndLabel".equals(compDisplay) ? values[j] + " " + compLabel : compLabel);
                }
            }
            if ((concatenatedLabel = StringUtils.join(displayedLabels, (String)separator)).compareTo("") == 0 && displayedLabels.length != 0) {
                concatenatedLabel = ChainSelectStatus.translate(context, "label.directories.error");
            }
            writer.write(concatenatedLabel);
            writer.endElement("div");
            if (i == selections.length - 1 || entrySeparator == null) continue;
            writer.write(entrySeparator);
        }
    }

    private UIParameter getUIParameter(UIComponent component) {
        UIParameter param = null;
        for (UIComponent child : component.getChildren()) {
            UIParameter paramChild;
            if (!(child instanceof UIParameter) || !REMOVE_ID.equals((paramChild = (UIParameter)child).getName())) continue;
            param = (UIParameter)child;
            break;
        }
        if (param == null) {
            param = new UIParameter();
            param.setName(REMOVE_ID);
            component.getChildren().add(param);
        }
        return param;
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        List children = this.getChildren();
        for (UIComponent component : children) {
            component.setRendered(true);
        }
    }

    public Object getProperty(String name) {
        ValueBinding vb = this.getValueBinding(name);
        if (vb != null) {
            return vb.getValue(FacesContext.getCurrentInstance());
        }
        Map attrMap = this.getAttributes();
        return attrMap.get(name);
    }

    public String getStringProperty(String name, String defaultValue) {
        String value = (String)this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public Boolean getBooleanProperty(String name, Boolean defaultValue) {
        Boolean value = (Boolean)this.getProperty(name);
        return value != null ? value : defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChainSelect getChain() {
        UIComponent component;
        for (component = this.getParent(); component != null && !(component instanceof ChainSelect); component = component.getParent()) {
        }
        return (ChainSelect)component;
    }

    public boolean isDisplayIncremental() {
        return this.displayIncremental;
    }

    public void setDisplayIncremental(boolean displayIncremental) {
        this.displayIncremental = displayIncremental;
    }

    public boolean isDisplayRoot() {
        return this.displayRoot;
    }

    public void setDisplayRoot(boolean displayRoot) {
        this.displayRoot = displayRoot;
    }

    public String getCssStyle() {
        return this.cssStyle;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public String getCssStyleClass() {
        return this.cssStyleClass;
    }

    public void setCssStyleClass(String cssStyleClass) {
        this.cssStyleClass = cssStyleClass;
    }

    public String getEntryCssStyle() {
        return this.entryCssStyle;
    }

    public void setEntryCssStyle(String entryCssStyle) {
        this.entryCssStyle = entryCssStyle;
    }

    public String getEntryCssStyleClass() {
        return this.entryCssStyleClass;
    }

    public void setEntryCssStyleClass(String entryCssStyleClass) {
        this.entryCssStyleClass = entryCssStyleClass;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }
}

