/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="testSeamRestlet")
@Scope(value=ScopeType.EVENT)
public class SimpleRestletWithSeam
extends Restlet
implements Serializable {
    private static final long serialVersionUID = -5264946092445282305L;
    @In(create=true)
    transient NavigationContext navigationContext;
    CoreSession documentManager;

    public void handle(Request req, Response res) {
        String repo = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            DocumentModel dm = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
            String title = (String)dm.getProperty("dublincore", "title");
            res.setEntity("doc =>" + title, MediaType.TEXT_PLAIN);
        }
        catch (NuxeoException e) {
            res.setEntity(e.getMessage(), MediaType.TEXT_PLAIN);
        }
    }
}

