/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import javax.faces.view.facelets.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class FaceletDebugTracer {
    private static final Log log = LogFactory.getLog(FaceletDebugTracer.class);
    public static final String TRACE_PROP = "nuxeo.jsf.debug.log_min_duration_ms";

    public static long start() {
        if (FaceletDebugTracer.getMaxTraceLag() >= 0L) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static void trace(long start, Tag tag, String id) {
        if (start > 0L) {
            FaceletDebugTracer.trace(start, tag, id, FaceletDebugTracer.getMaxTraceLag());
        }
    }

    public static void traceMillis(long start, Tag tag, String id) {
        FaceletDebugTracer.trace(start, tag, id, 0L);
    }

    public static void trace(long start, Tag tag, String id, long maxLag) {
        long end;
        long lag;
        if (start > 0L && maxLag >= 0L && (lag = (end = System.currentTimeMillis()) - start) >= maxLag) {
            log.debug((Object)String.format("'%s' at '%s' took: %s ms.", id, tag, lag));
        }
    }

    protected static long getMaxTraceLag() {
        if (log.isDebugEnabled()) {
            ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
            return Long.valueOf(cs.getProperty(TRACE_PROP, "-1"));
        }
        return -1L;
    }
}

