/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.list;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ui.component.UIFileUpload;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelect;

final class StampState
implements Externalizable {
    private static final long serialVersionUID = -4207557910028866684L;
    private static final Log log = LogFactory.getLog(StampState.class);
    private static final Object[] _EMPTY_ARRAY = new Object[0];
    private Map<DualKey, Object> rows = Collections.emptyMap();

    public void clear(Object skipCurrencyObj) {
        if (!this.rows.isEmpty()) {
            Iterator<DualKey> iter = this.rows.keySet().iterator();
            while (iter.hasNext()) {
                DualKey dk = iter.next();
                if (StampState._eq(dk.key1, skipCurrencyObj)) continue;
                iter.remove();
            }
        }
    }

    public void clearIndex(int index) {
        if (!this.rows.isEmpty()) {
            Iterator<DualKey> iter = this.rows.keySet().iterator();
            while (iter.hasNext()) {
                DualKey dk = iter.next();
                if (!StampState._eq(dk.key1, index)) continue;
                iter.remove();
            }
        }
    }

    public void put(Object currencyObj, String key, Object value) {
        Map comparant = Collections.emptyMap();
        if (this.rows == comparant) {
            this.rows = new HashMap<DualKey, Object>(109);
        }
        DualKey dk = new DualKey(currencyObj, key);
        this.rows.put(dk, value);
    }

    public int size() {
        return this.rows.size();
    }

    public Object get(Object currencyObj, String key) {
        DualKey dk = new DualKey(currencyObj, key);
        return this.rows.get(dk);
    }

    public static Object saveStampState(FacesContext context, UIComponent stamp) {
        Object[] childStateArray;
        Object[] facetState;
        if (stamp.isTransient()) {
            return null;
        }
        Object[] selfState = new Object[5];
        Object[] innerSelfState = new Object[5];
        if (stamp instanceof ChainSelect) {
            innerSelfState[0] = stamp.saveState(context);
        } else if (stamp instanceof UIFileUpload) {
            innerSelfState[0] = stamp.saveState(context);
            UIFileUpload fileUpload = (UIFileUpload)stamp;
            innerSelfState[1] = fileUpload.getLocalContentType();
            innerSelfState[2] = fileUpload.getLocalFileName();
            innerSelfState[3] = fileUpload.getLocalFileSize();
            innerSelfState[4] = fileUpload.getLocalInputStream();
        } else if (stamp instanceof UIEditableList) {
            innerSelfState[0] = stamp.saveState(context);
        }
        selfState[0] = innerSelfState;
        if (stamp instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)stamp;
            selfState[1] = evh.getSubmittedValue();
            selfState[2] = evh.getLocalValue();
            selfState[3] = evh.isLocalValueSet();
            selfState[4] = evh.isValid();
        }
        Object[] state = new Object[3];
        state[0] = selfState;
        int facetCount = stamp.getFacets().size();
        if (facetCount == 0) {
            facetState = _EMPTY_ARRAY;
        } else {
            facetState = new Object[facetCount * 2];
            Map facetMap = stamp.getFacets();
            int i = 0;
            for (Map.Entry entry : facetMap.entrySet()) {
                int base = i * 2;
                UIComponent facet = (UIComponent)entry.getValue();
                if (facet.isTransient()) continue;
                facetState[base] = entry.getKey();
                facetState[base + 1] = StampState.saveStampState(context, (UIComponent)entry.getValue());
                ++i;
            }
        }
        state[1] = facetState;
        int childCount = stamp.getChildCount();
        if (childCount == 0) {
            childStateArray = _EMPTY_ARRAY;
        } else {
            childStateArray = new Object[childCount];
            boolean wasAllTransient = true;
            int i = 0;
            for (UIComponent child : stamp.getChildren()) {
                if (!child.isTransient()) {
                    wasAllTransient = false;
                    childStateArray[i] = StampState.saveStampState(context, child);
                }
                ++i;
            }
            if (wasAllTransient) {
                childStateArray = _EMPTY_ARRAY;
            }
        }
        state[2] = childStateArray;
        return state;
    }

    public static void restoreStampState(FacesContext context, UIComponent stamp, Object stampState) {
        if (stampState == null || stamp == null) {
            return;
        }
        Object[] state = (Object[])stampState;
        Object[] selfState = (Object[])state[0];
        Object[] innerSelfState = (Object[])selfState[0];
        if (stamp instanceof ChainSelect) {
            stamp.restoreState(context, innerSelfState[0]);
        } else if (stamp instanceof UIFileUpload) {
            stamp.restoreState(context, innerSelfState[0]);
            UIFileUpload fileUpload = (UIFileUpload)stamp;
            fileUpload.setLocalContentType((String)innerSelfState[1]);
            fileUpload.setLocalFileName((String)innerSelfState[2]);
            fileUpload.setLocalFileSize((Integer)innerSelfState[3]);
            fileUpload.setLocalInputStream((InputStream)innerSelfState[4]);
        } else if (stamp instanceof UIEditableList) {
            stamp.restoreState(context, innerSelfState[0]);
        }
        if (stamp instanceof EditableValueHolder) {
            EditableValueHolder evh = (EditableValueHolder)stamp;
            evh.setSubmittedValue(selfState[1]);
            evh.setValue(selfState[2]);
            if (selfState[3] != null) {
                evh.setLocalValueSet(((Boolean)selfState[3]).booleanValue());
            } else {
                evh.setLocalValueSet(false);
            }
            if (selfState[4] != null) {
                evh.setValid(((Boolean)selfState[4]).booleanValue());
            }
        }
        stamp.setId(stamp.getId());
        Object[] facetStateArray = (Object[])state[1];
        for (int i = 0; i < facetStateArray.length; i += 2) {
            String facetName = (String)facetStateArray[i];
            Object facetState = facetStateArray[i + 1];
            StampState.restoreStampState(context, stamp.getFacet(facetName), facetState);
        }
        Object[] childStateArray = (Object[])state[2];
        int childArrayCount = childStateArray.length;
        int i = 0;
        for (UIComponent child : stamp.getChildren()) {
            if (!child.isTransient() && i < childArrayCount) {
                StampState.restoreStampState(context, child, childStateArray[i]);
            }
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows.size());
        if (this.rows.isEmpty()) {
            return;
        }
        HashMap<DualKey, Object> map = new HashMap<DualKey, Object>(this.rows.size());
        map.putAll(this.rows);
        if (log.isDebugEnabled()) {
            for (Map.Entry entry : map.entrySet()) {
                log.debug((Object)("Saving " + entry.getKey() + ", " + entry.getValue()));
            }
        }
        out.writeObject(map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size > 0) {
            this.rows = (Map)in.readObject();
        }
        if (log.isDebugEnabled()) {
            for (Map.Entry<DualKey, Object> entry : this.rows.entrySet()) {
                log.debug((Object)("Restoring " + entry.getKey() + ", " + entry.getValue()));
            }
        }
    }

    private static boolean _eq(Object k1, Object k2) {
        if (k1 == null) {
            return k2 == null;
        }
        return k1.equals(k2);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("StampState");
        buf.append(" {");
        buf.append(" rows=");
        buf.append(this.rows);
        buf.append('}');
        return buf.toString();
    }

    private static final class DualKey
    implements Serializable {
        private static final long serialVersionUID = 8302554393951287224L;
        private final Object key1;
        private final Object key2;
        private final int hash;

        DualKey(Object key1, Object key2) {
            this.key1 = key1;
            this.key2 = key2;
            this.hash = (key1 == null ? 0 : key1.hashCode()) + (key2 == null ? 0 : key2.hashCode());
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof DualKey) {
                DualKey otherKey = (DualKey)other;
                if (this.hashCode() != otherKey.hashCode()) {
                    return false;
                }
                return StampState._eq(this.key1, otherKey.key1) && StampState._eq(this.key2, otherKey.key2);
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "<" + this.key1 + ',' + this.key2 + '>';
        }
    }
}

