/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.interpolator;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.hibernate.AssertionFailure;
import org.hibernate.validator.MessageInterpolator;
import org.hibernate.validator.Validator;
import org.hibernate.validator.interpolator.DefaultMessageInterpolator;

public class DefaultMessageInterpolatorAggregator
implements MessageInterpolator,
Serializable {
    private transient Map<Validator, DefaultMessageInterpolator> interpolators = new HashMap<Validator, DefaultMessageInterpolator>();
    private transient ResourceBundle messageBundle;
    private transient ResourceBundle defaultMessageBundle;

    public void initialize(ResourceBundle messageBundle, ResourceBundle defaultMessageBundle) {
        this.messageBundle = messageBundle;
        this.defaultMessageBundle = defaultMessageBundle;
        for (DefaultMessageInterpolator interpolator : this.interpolators.values()) {
            interpolator.initialize(messageBundle, defaultMessageBundle);
        }
    }

    public void addInterpolator(Annotation annotation, Validator validator) {
        DefaultMessageInterpolator interpolator = new DefaultMessageInterpolator();
        interpolator.initialize(this.messageBundle, this.defaultMessageBundle);
        interpolator.initialize(annotation, null);
        this.interpolators.put(validator, interpolator);
    }

    public String interpolate(String message, Validator validator, MessageInterpolator defaultInterpolator) {
        DefaultMessageInterpolator defaultMessageInterpolator = this.interpolators.get(validator);
        if (defaultMessageInterpolator == null) {
            return message;
        }
        return defaultMessageInterpolator.interpolate(message, validator, defaultInterpolator);
    }

    public String getAnnotationMessage(Validator validator) {
        String message;
        DefaultMessageInterpolator defaultMessageInterpolator = this.interpolators.get(validator);
        String string = message = defaultMessageInterpolator != null ? defaultMessageInterpolator.getAnnotationMessage() : null;
        if (message == null) {
            throw new AssertionFailure("Validator not registred to the messageInterceptorAggregator");
        }
        return message;
    }
}

