/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.component.SelectItemFactory;
import org.nuxeo.ecm.platform.ui.web.component.VariableManager;
import org.nuxeo.runtime.api.Framework;

public abstract class UserAndGroupSelectItemFactory
extends SelectItemFactory {
    @Override
    protected abstract String getVar();

    protected abstract String retrieveSelectEntryId();

    protected abstract SelectItem createSelectItem(String var1);

    protected abstract String getItemLabel();

    protected abstract String getDirectoryName();

    protected abstract String getGroupDirectoryName();

    protected abstract String getGroupItemLabel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectItem createSelectItem(Object value) {
        SelectItem item = null;
        if (value instanceof SelectItem) {
            Object varValue = this.saveRequestMapVarValue();
            try {
                this.putIteratorToRequestParam(value);
                item = this.createSelectItem();
                this.removeIteratorFromRequestParam();
            }
            finally {
                this.restoreRequestMapVarValue(varValue);
            }
        }
        if (value instanceof String) {
            Object varValue = this.saveRequestMapVarValue();
            try {
                item = this.getSelectItem(value);
            }
            finally {
                this.restoreRequestMapVarValue(varValue);
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectItem getSelectItem(Object value) {
        Throwable throwable;
        String entryId = this.retrieveEntryIdFrom(value);
        DocumentModel entry = null;
        boolean isGroup = false;
        boolean isUser = false;
        if (entryId.startsWith("group:")) {
            entryId = entryId.substring("group:".length());
            isGroup = true;
        } else if (entryId.startsWith("user:")) {
            entryId = entryId.substring("user:".length());
            isUser = true;
        }
        boolean unprefixed = !isGroup && !isUser;
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        if (isGroup || unprefixed) {
            throwable = null;
            try (Session groupDir = dirService.open(this.getGroupDirectoryName(), null);){
                entry = groupDir.getEntry(entryId);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (isUser || unprefixed && entry == null) {
            throwable = null;
            try (Session userDir = dirService.open(this.getDirectoryName(), null);){
                entry = userDir.getEntry(entryId);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        String var = this.getVar();
        String varId = var + "Id";
        Object varIdExisting = VariableManager.saveRequestMapVarValue(varId);
        String varEntry = var + "Entry";
        Object varEntryExisting = VariableManager.saveRequestMapVarValue(varEntry);
        try {
            VariableManager.putVariableToRequestParam(var, value);
            VariableManager.putVariableToRequestParam(varId, entryId);
            VariableManager.putVariableToRequestParam(varEntry, entry);
            String label = "";
            if (isGroup || unprefixed) {
                label = this.getGroupItemLabel();
            }
            if (isUser || unprefixed && StringUtils.isBlank((CharSequence)label)) {
                label = this.getItemLabel();
            }
            if (StringUtils.isBlank((CharSequence)label) && entry != null) {
                label = entry.toString();
            }
            SelectItem item = this.createSelectItem(label);
            VariableManager.removeVariableFromRequestParam(var);
            VariableManager.removeVariableFromRequestParam(varId);
            VariableManager.removeVariableFromRequestParam(varEntry);
            SelectItem selectItem = item;
            return selectItem;
        }
        finally {
            VariableManager.restoreRequestMapVarValue(varId, varIdExisting);
            VariableManager.restoreRequestMapVarValue(varEntry, varEntryExisting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectItem> createSelectItems(Object value) {
        Object varValue = this.saveRequestMapVarValue();
        try {
            ArrayList<SelectItem> items = new ArrayList<SelectItem>();
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object entry : collection) {
                    SelectItem res = this.getSelectItem(entry);
                    if (res == null) continue;
                    items.add(res);
                }
            } else if (value instanceof Object[]) {
                Object[] entries;
                for (Object entry : entries = (Object[])value) {
                    SelectItem res = this.getSelectItem(entry);
                    if (res == null) continue;
                    items.add(res);
                }
            }
            ArrayList<SelectItem> arrayList = items;
            return arrayList;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String retrieveEntryIdFrom(Object item) {
        Object varValue = this.saveRequestMapVarValue();
        try {
            this.putIteratorToRequestParam(item);
            String id = this.retrieveSelectEntryId();
            this.removeIteratorFromRequestParam();
            String string = id;
            return string;
        }
        finally {
            this.restoreRequestMapVarValue(varValue);
        }
    }
}

