/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.interpolator;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.hibernate.util.StringHelper;
import org.hibernate.validator.MessageInterpolator;
import org.hibernate.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageInterpolator
implements MessageInterpolator,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DefaultMessageInterpolator.class);
    private Map<String, Object> annotationParameters = new HashMap<String, Object>();
    private transient ResourceBundle messageBundle;
    private transient ResourceBundle defaultMessageBundle;
    private String annotationMessage;
    private String interpolateMessage;

    public void initialize(ResourceBundle messageBundle, ResourceBundle defaultMessageBundle) {
        this.messageBundle = messageBundle;
        this.defaultMessageBundle = defaultMessageBundle;
    }

    public void initialize(Annotation annotation, MessageInterpolator defaultInterpolator) {
        Class<?> clazz = annotation.getClass();
        for (Method method : clazz.getMethods()) {
            try {
                if (method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers())) continue;
                this.annotationParameters.put(method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            catch (IllegalAccessException e) {
                log.warn("Unable to access {}", (Object)StringHelper.qualify((String)clazz.toString(), (String)method.getName()));
            }
            catch (InvocationTargetException e) {
                log.warn("Unable to access {}", (Object)StringHelper.qualify((String)clazz.toString(), (String)method.getName()));
            }
        }
        this.annotationMessage = (String)this.annotationParameters.get("message");
        if (this.annotationMessage == null) {
            throw new IllegalArgumentException("Annotation " + clazz + " does not have an (accessible) message attribute");
        }
    }

    private String replace(String message) {
        StringTokenizer tokens = new StringTokenizer(message, "#{}", true);
        StringBuilder buf = new StringBuilder(30);
        boolean escaped = false;
        boolean el = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!escaped && "#".equals(token)) {
                el = true;
            }
            if (!el && "{".equals(token)) {
                escaped = true;
                continue;
            }
            if (escaped && "}".equals(token)) {
                escaped = false;
                continue;
            }
            if (!escaped) {
                if ("{".equals(token)) {
                    el = false;
                }
                buf.append(token);
                continue;
            }
            Object variable = this.annotationParameters.get(token);
            if (variable != null) {
                buf.append(variable);
                continue;
            }
            String string = null;
            try {
                string = this.messageBundle != null ? this.messageBundle.getString(token) : null;
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            if (string == null) {
                try {
                    string = this.defaultMessageBundle.getString(token);
                }
                catch (MissingResourceException e) {
                    buf.append('{').append(token).append('}');
                }
            }
            if (string == null) continue;
            buf.append(this.replace(string));
        }
        return buf.toString();
    }

    public String interpolate(String message, Validator validator, MessageInterpolator defaultInterpolator) {
        if (this.annotationMessage.equals(message)) {
            if (this.interpolateMessage == null) {
                this.interpolateMessage = this.replace(this.annotationMessage);
            }
            return this.interpolateMessage;
        }
        return this.replace(message);
    }

    public String getAnnotationMessage() {
        return this.annotationMessage;
    }
}

