/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.UISelectMany;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.util.ComponentRenderUtils;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public final class ComponentUtils {
    public static final String WHITE_SPACE_CHARACTER = "&#x0020;";
    private static final Log log = LogFactory.getLog(ComponentUtils.class);
    public static final String FORCE_NO_CACHE_ON_MSIE = "org.nuxeo.download.force.nocache.msie";
    public static String NUXEO_RESOURCE_RELOCATED = "NUXEO_RESOURCE_RELOCATED_MARKER";

    private ComponentUtils() {
    }

    public static void encodeComponent(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        component.encodeChildren(context);
        component.encodeEnd(context);
    }

    public static void initiateSubComponent(UIComponent parent, String facetName, UIComponent child) {
        parent.getFacets().put(facetName, child);
        ComponentUtils.hookSubComponent(null, parent, child, facetName);
    }

    public static UIComponent hookSubComponent(FacesContext context, UIComponent parent, UIComponent child, String defaultChildId) {
        String childId = child.getId();
        if (defaultChildId != null) {
            childId = defaultChildId;
        }
        if (childId == null) {
            childId = context.getViewRoot().createUniqueId();
        }
        child.setId(childId);
        child.setParent(parent);
        return child;
    }

    public static void copyValues(UIComponent parent, UIComponent child, String[] valueNames) {
        Map parentAttributes = parent.getAttributes();
        Map childAttributes = child.getAttributes();
        for (String name : valueNames) {
            ValueExpression ve;
            if (parentAttributes.containsKey(name)) {
                childAttributes.put(name, parentAttributes.get(name));
            }
            if ((ve = parent.getValueExpression(name)) == null) continue;
            child.setValueExpression(name, ve);
        }
    }

    public static void copyLinkValues(UIComponent parent, UIComponent child) {
        String[] valueNames = new String[]{"accesskey", "charset", "coords", "dir", "disabled", "hreflang", "lang", "onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "rel", "rev", "shape", "style", "styleClass", "tabindex", "target", "title", "type"};
        ComponentUtils.copyValues(parent, child, valueNames);
    }

    public static Object getAttributeValue(UIComponent component, String attributeName, Object defaultValue) {
        return ComponentUtils.getAttributeValue(component, attributeName, Object.class, defaultValue, false);
    }

    public static <T> T getAttributeValue(UIComponent component, String name, Class<T> klass, T defaultValue, boolean required) {
        Object value = component.getAttributes().get(name);
        if (value == null) {
            value = defaultValue;
        }
        if (required && value == null) {
            throw new IllegalArgumentException("Component attribute with name '" + name + "' cannot be null: " + value);
        }
        if (value == null || value.getClass().isAssignableFrom(klass)) {
            return (T)value;
        }
        throw new IllegalArgumentException("Component attribute with name '" + name + "' is not a " + klass + ": " + value);
    }

    public static Object getAttributeOrExpressionValue(FacesContext context, UIComponent component, String attributeName, Object defaultValue) {
        Object value = component.getAttributes().get(attributeName);
        if (value == null) {
            ValueExpression schemaExpr = component.getValueExpression(attributeName);
            value = schemaExpr.getValue(context.getELContext());
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void download(DocumentModel doc, String xpath, Blob blob, String filename, String reason) {
        ComponentUtils.download(doc, xpath, blob, filename, reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(DocumentModel doc, String xpath, Blob blob, String filename, String reason, Map<String, Serializable> extendedInfos) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext.getResponseComplete()) {
            log.debug((Object)("Cannot send " + filename + ", response already complete"));
            return;
        }
        if (facesContext.getPartialViewContext().isAjaxRequest()) {
            return;
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
        try {
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            downloadService.downloadBlob(request, response, doc, xpath, blob, filename, reason, extendedInfos);
        }
        catch (IOException e) {
            log.error((Object)("Error while downloading the file: " + filename), (Throwable)e);
        }
        finally {
            facesContext.responseComplete();
        }
    }

    public static String downloadFile(File file, String filename, String reason) throws IOException {
        Blob blob = Blobs.createBlob((File)file);
        ComponentUtils.download(null, null, blob, filename, reason);
        return null;
    }

    @Deprecated
    public static String download(FacesContext faces, Blob blob, String filename) {
        ComponentUtils.download(null, null, blob, filename, "download");
        return null;
    }

    @Deprecated
    public static String downloadFile(FacesContext faces, String filename, File file) throws IOException {
        return ComponentUtils.downloadFile(file, filename, null);
    }

    protected static boolean forceNoCacheOnMSIE() {
        return Framework.isBooleanPropertyTrue((String)FORCE_NO_CACHE_ON_MSIE);
    }

    public static String translate(FacesContext context, String messageId) {
        return ComponentUtils.translate(context, messageId, null);
    }

    public static String translate(FacesContext context, String messageId, Object ... params) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        return I18NUtils.getMessageString((String)bundleName, (String)messageId, (Object[])ComponentUtils.evaluateParams(context, params), (Locale)locale);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String message) {
        ComponentUtils.addErrorMessage(context, component, message, null);
    }

    public static void addErrorMessage(FacesContext context, UIComponent component, String message, Object[] params) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        message = I18NUtils.getMessageString((String)bundleName, (String)message, (Object[])ComponentUtils.evaluateParams(context, params), (Locale)locale);
        FacesMessage msg = new FacesMessage(message);
        msg.setSeverity(FacesMessage.SEVERITY_ERROR);
        context.addMessage(component.getClientId(context), msg);
    }

    protected static Object[] evaluateParams(FacesContext context, Object[] params) {
        if (params == null) {
            return null;
        }
        Object[] res = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object val = params[i];
            if (val instanceof String && ComponentTagUtils.isValueReference((String)val)) {
                ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), (String)val, Object.class);
                res[i] = ve.getValue(context.getELContext());
                continue;
            }
            res[i] = val;
        }
        return res;
    }

    public static UIComponent getBase(UIComponent anchor) {
        UIComponent supContainer;
        UIComponent base = anchor;
        UIComponent container = anchor.getNamingContainer();
        if (container != null && (supContainer = container.getNamingContainer()) != null) {
            container = supContainer;
        }
        if (container != null) {
            base = container;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resolved base '%s' for anchor '%s'", base.getId(), anchor.getId()));
        }
        return base;
    }

    public static <T> T getComponent(UIComponent base, String componentId, Class<T> expectedComponentClass) {
        if (componentId == null) {
            log.error((Object)"Cannot retrieve component with a null id");
            return null;
        }
        UIComponent component = ComponentRenderUtils.getComponent(base, componentId);
        if (component == null) {
            log.error((Object)("Could not find component with id: " + componentId));
        } else {
            try {
                return (T)component;
            }
            catch (ClassCastException e) {
                log.error((Object)("Invalid component with id '" + componentId + "': " + component + ", expected a component with interface " + expectedComponentClass));
            }
        }
        return null;
    }

    static void clearTargetList(UIEditableList targetList) {
        int rc = targetList.getRowCount();
        for (int i = 0; i < rc; ++i) {
            targetList.removeValue(0);
        }
    }

    static void addToTargetList(UIEditableList targetList, SelectItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            targetList.addValue(items[i].getValue());
        }
    }

    public static void shiftItemsUp(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        ComponentUtils.shiftUp(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    public static void shiftItemsDown(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        ComponentUtils.shiftDown(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    public static void shiftItemsFirst(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        all = ComponentUtils.shiftFirst(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    public static void shiftItemsLast(UISelectMany targetSelect, UISelectItems targetItems, UIEditableList hiddenTargetList) {
        String[] selected = (String[])targetSelect.getSelectedValues();
        SelectItem[] all = (SelectItem[])targetItems.getValue();
        if (selected == null) {
            return;
        }
        all = ComponentUtils.shiftLast(selected, all);
        targetItems.setValue((Object)all);
        ComponentUtils.clearTargetList(hiddenTargetList);
        ComponentUtils.addToTargetList(hiddenTargetList, all);
    }

    static SelectItem[] shiftFirst(String[] selected, SelectItem[] all) {
        SelectItem[] res = new SelectItem[all.length];
        int sl = selected.length;
        int i = 0;
        int j = sl;
        for (SelectItem item : all) {
            if (i < sl && item.getValue().toString().equals(selected[i])) {
                res[i++] = item;
                continue;
            }
            res[j++] = item;
        }
        return res;
    }

    static SelectItem[] shiftLast(String[] selected, SelectItem[] all) {
        SelectItem[] res = new SelectItem[all.length];
        int sl = selected.length;
        int cut = all.length - sl;
        int i = 0;
        int j = 0;
        for (SelectItem item : all) {
            if (i < sl && item.getValue().toString().equals(selected[i])) {
                res[cut + i++] = item;
                continue;
            }
            res[j++] = item;
        }
        return res;
    }

    static void swap(Object[] ar, int i, int j) {
        Object t = ar[i];
        ar[i] = ar[j];
        ar[j] = t;
    }

    static void shiftUp(String[] selected, SelectItem[] all) {
        int pos = -1;
        for (int i = 0; i < selected.length; ++i) {
            String s = selected[i];
            int previous = pos;
            while (!all[++pos].getValue().equals(s)) {
            }
            if (pos <= previous + 1) continue;
            ComponentUtils.swap(all, pos--, pos);
        }
    }

    static void shiftDown(String[] selected, SelectItem[] all) {
        int pos = all.length;
        for (int i = selected.length - 1; i >= 0; --i) {
            String s = selected[i];
            int previous = pos;
            while (!all[--pos].getValue().equals(s)) {
            }
            if (pos >= previous - 1) continue;
            ComponentUtils.swap(all, pos++, pos);
        }
    }

    public static void moveItems(UISelectMany sourceSelect, UISelectItems sourceItems, UISelectItems targetItems, UIEditableList hiddenTargetList, boolean setTargetIds) {
        String[] selected = (String[])sourceSelect.getSelectedValues();
        if (selected == null) {
            return;
        }
        List<String> selectedList = Arrays.asList(selected);
        SelectItem[] all = (SelectItem[])sourceItems.getValue();
        ArrayList<SelectItem[]> toMove = new ArrayList<SelectItem[]>();
        ArrayList<SelectItem[]> toKeep = new ArrayList<SelectItem[]>();
        ArrayList<String> hiddenIds = new ArrayList<String>();
        if (all != null) {
            for (SelectItem item : all) {
                String string = item.getValue().toString();
                if (selectedList.contains(string)) {
                    toMove.add((SelectItem[])item);
                    continue;
                }
                toKeep.add((SelectItem[])item);
                if (setTargetIds) continue;
                hiddenIds.add(string);
            }
        }
        sourceItems.setValue((Object)toKeep.toArray(new SelectItem[0]));
        sourceSelect.setSelectedValues(new Object[0]);
        ArrayList<Object> newSelectItems = new ArrayList<Object>();
        SelectItem[] oldSelectItems = (SelectItem[])targetItems.getValue();
        if (oldSelectItems == null) {
            newSelectItems.addAll(toMove);
        } else {
            newSelectItems.addAll(Arrays.asList(oldSelectItems));
            ArrayList<String> oldIds = new ArrayList<String>();
            for (SelectItem oldItem : oldSelectItems) {
                String id = oldItem.getValue().toString();
                oldIds.add(id);
            }
            if (setTargetIds) {
                hiddenIds.addAll(0, oldIds);
            }
            for (SelectItem selectItem : toMove) {
                String id = selectItem.getValue().toString();
                if (oldIds.contains(id)) continue;
                newSelectItems.add(selectItem);
                if (!setTargetIds) continue;
                hiddenIds.add(id);
            }
        }
        targetItems.setValue((Object)newSelectItems.toArray(new SelectItem[0]));
        int numValues = hiddenTargetList.getRowCount();
        if (numValues > 0) {
            for (int i = numValues - 1; i > -1; --i) {
                hiddenTargetList.removeValue(i);
            }
        }
        for (String string : hiddenIds) {
            hiddenTargetList.addValue(string);
        }
    }

    public static void moveAllItems(UISelectItems sourceItems, UISelectItems targetItems, UIEditableList hiddenTargetList, boolean setTargetIds) {
        SelectItem[] all = (SelectItem[])sourceItems.getValue();
        ArrayList<SelectItem[]> toMove = new ArrayList<SelectItem[]>();
        ArrayList<SelectItem[]> toKeep = new ArrayList<SelectItem[]>();
        ArrayList hiddenIds = new ArrayList();
        if (all != null) {
            for (SelectItem item : all) {
                if (!item.isDisabled()) {
                    toMove.add((SelectItem[])item);
                    continue;
                }
                toKeep.add((SelectItem[])item);
            }
        }
        sourceItems.setValue((Object)toKeep.toArray(new SelectItem[0]));
        ArrayList<Object> newSelectItems = new ArrayList<Object>();
        SelectItem[] oldSelectItems = (SelectItem[])targetItems.getValue();
        if (oldSelectItems == null) {
            newSelectItems.addAll(toMove);
        } else {
            newSelectItems.addAll(Arrays.asList(oldSelectItems));
            ArrayList<String> oldIds = new ArrayList<String>();
            for (SelectItem oldItem : oldSelectItems) {
                String id = oldItem.getValue().toString();
                oldIds.add(id);
            }
            if (setTargetIds) {
                hiddenIds.addAll(0, oldIds);
            }
            for (SelectItem selectItem : toMove) {
                String id = selectItem.getValue().toString();
                if (oldIds.contains(id)) continue;
                newSelectItems.add(selectItem);
                if (!setTargetIds) continue;
                hiddenIds.add(id);
            }
        }
        targetItems.setValue((Object)newSelectItems.toArray(new SelectItem[0]));
        int numValues = hiddenTargetList.getRowCount();
        if (numValues > 0) {
            for (int i = numValues - 1; i > -1; --i) {
                hiddenTargetList.removeValue(i);
            }
        }
        for (String string : hiddenIds) {
            hiddenTargetList.addValue(string);
        }
    }

    public static String verifyTarget(String toVerify, String defaultTarget) {
        if (StringUtils.isBlank((String)toVerify)) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
        if (ajaxRequest) {
            return null;
        }
        return defaultTarget;
    }

    public static void setRelocated(UIComponent component) {
        component.getAttributes().put(NUXEO_RESOURCE_RELOCATED, "true");
    }

    public static boolean isRelocated(UIComponent component) {
        return component.getAttributes().containsKey(NUXEO_RESOURCE_RELOCATED);
    }

    public static void relocate(UIComponent component, String target, String compositeKey) {
        UIComponent cc;
        FacesContext context = FacesContext.getCurrentInstance();
        if (compositeKey != null && (cc = UIComponent.getCurrentCompositeComponent((FacesContext)context)) != null) {
            component.getAttributes().put(compositeKey, cc.getClientId(context));
        }
        if (ComponentUtils.isRendered(component)) {
            ComponentUtils.setRelocated(component);
            context.getViewRoot().addComponentResource(context, component, target);
        }
    }

    protected static boolean isRendered(UIComponent component) {
        UIComponent comp = component;
        while (comp.isRendered()) {
            UIComponent parent = comp.getParent();
            if (parent == null) {
                return true;
            }
            comp = parent;
        }
        return false;
    }
}

