/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.live.commands;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.live.commands.Undeploy;
import org.nuxeo.connect.update.task.update.Rollback;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;

public class RollbackAndUndeploy
extends Rollback {
    public RollbackAndUndeploy() {
    }

    public RollbackAndUndeploy(RollbackOptions opt) {
        super(opt);
    }

    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        Command res = null;
        try {
            res = super.doRun(task, prefs);
            ReloadService srv = (ReloadService)Framework.getLocalService(ReloadService.class);
            srv.runDeploymentPreprocessor();
        }
        catch (IOException | PackageException e) {
            task.setRestartRequired(true);
            throw new PackageException("Failed to undeploy bundle", e);
        }
        return res;
    }

    protected Command getUndeployCommand(File targetFile) {
        return new Undeploy(targetFile);
    }
}

