/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;

public class BasicContext
implements Context {
    private final Map<String, Object> map;
    private final ScopeType scope;

    public BasicContext(ScopeType scope) {
        this.scope = scope;
        this.map = new HashMap<String, Object>();
    }

    protected BasicContext(ScopeType scope, Map<String, Object> map) {
        this.scope = scope;
        this.map = map;
    }

    @Override
    public ScopeType getType() {
        return this.scope;
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Component.getComponentName(clazz));
    }

    @Override
    public Object get(String name) {
        return this.map.get(name);
    }

    @Override
    public String[] getNames() {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            keys.add(key);
        }
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public boolean isSet(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public void remove(String name) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name, new Object[0]);
        }
        this.map.remove(name);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name, new Object[0]);
        }
    }

    @Override
    public void set(String name, Object value) {
        if (!Seam.getComponentName(Events.class).equals(name) && Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name, new Object[0]);
        }
        this.map.put(name, value);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name, new Object[0]);
        }
    }

    @Override
    public void flush() {
    }

    public String toString() {
        return "BasicContext(" + (Object)((Object)this.scope) + ")";
    }
}

