/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.exception.ExceptionHandler;
import org.jboss.seam.faces.RedirectException;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.navigation.Pages;

public abstract class RedirectHandler
extends ExceptionHandler {
    private static final LogProvider log = Logging.getLogProvider(RedirectHandler.class);

    protected abstract String getViewId(Exception var1);

    protected abstract String getMessage(Exception var1);

    protected abstract boolean isEnd(Exception var1);

    protected abstract FacesMessage.Severity getMessageSeverity(Exception var1);

    @Override
    public void handle(Exception e) throws Exception {
        String viewId = this.getViewId(e);
        if (viewId == null) {
            String servletPath = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getServletPath();
            viewId = servletPath.substring(0, servletPath.lastIndexOf(46)) + Pages.getSuffix();
        }
        RedirectHandler.addFacesMessage("#0", this.getMessageSeverity(e), null, RedirectHandler.getDisplayMessage(e, this.getMessage(e)));
        if (Contexts.isConversationContextActive() && this.isEnd(e)) {
            Conversation.instance().end();
        }
        try {
            this.redirect(viewId, null);
        }
        catch (RedirectException re) {
            log.debug("could not redirect", re);
        }
    }

    public String toString() {
        return "RedirectHandler";
    }
}

