/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.navigation;

import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Manager;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;

public class ConversationControl {
    private boolean isBeginConversation;
    private boolean isEndConversation;
    private boolean isEndConversationBeforeRedirect;
    private boolean isEndRootConversation;
    private boolean join;
    private boolean nested;
    private FlushModeType flushMode;
    private String pageflow;
    private Expressions.ValueExpression<Boolean> beginConversationCondition;
    private Expressions.ValueExpression<Boolean> endConversationCondition;
    private String conversationName;

    public boolean isBeginConversation() {
        return this.isBeginConversation;
    }

    public void setBeginConversation(boolean isBeginConversation) {
        this.isBeginConversation = isBeginConversation;
    }

    public boolean isEndConversation() {
        return this.isEndConversation;
    }

    public void setEndConversation(boolean isEndConversation) {
        this.isEndConversation = isEndConversation;
    }

    public void beginOrEndConversation() {
        if (this.endConversation()) {
            if (this.isEndRootConversation) {
                Manager.instance().endRootConversation(this.isEndConversationBeforeRedirect);
            } else {
                Manager.instance().endConversation(this.isEndConversationBeforeRedirect);
            }
        }
        if (this.beginConversation()) {
            boolean begun;
            if (this.conversationName != null) {
                ConversationIdParameter param = Pages.instance().getConversationIdParameter(this.conversationName);
                ConversationEntry ce = ConversationEntries.instance().getConversationEntry(param.getConversationId());
                if (ce != null) {
                    ce.redirect();
                    return;
                }
            }
            if (begun = Conversation.instance().begin(this.join, this.nested)) {
                if (this.flushMode != null) {
                    Conversation.instance().changeFlushMode(this.flushMode);
                }
                if (this.pageflow != null) {
                    Pageflow.instance().begin(this.pageflow);
                }
            }
        }
    }

    private boolean beginConversation() {
        return this.isBeginConversation && (this.beginConversationCondition == null || Boolean.TRUE.equals(this.beginConversationCondition.getValue()));
    }

    private boolean endConversation() {
        return this.isEndConversation && (this.endConversationCondition == null || Boolean.TRUE.equals(this.endConversationCondition.getValue()));
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public String getPageflow() {
        return this.pageflow;
    }

    public void setPageflow(String pageflow) {
        this.pageflow = pageflow;
    }

    public boolean isEndConversationBeforeRedirect() {
        return this.isEndConversationBeforeRedirect;
    }

    public void setEndConversationBeforeRedirect(boolean isEndConversationBeforeRedirect) {
        this.isEndConversationBeforeRedirect = isEndConversationBeforeRedirect;
    }

    public boolean isEndRootConversation() {
        return this.isEndConversationBeforeRedirect;
    }

    public void setEndRootConversation(boolean isEndRootConversation) {
        this.isEndRootConversation = isEndRootConversation;
    }

    public Expressions.ValueExpression<Boolean> getBeginConversationCondition() {
        return this.beginConversationCondition;
    }

    public void setBeginConversationCondition(Expressions.ValueExpression<Boolean> beginConversationCondition) {
        this.beginConversationCondition = beginConversationCondition;
    }

    public Expressions.ValueExpression<Boolean> getEndConversationCondition() {
        return this.endConversationCondition;
    }

    public void setEndConversationCondition(Expressions.ValueExpression<Boolean> endConversationCondition) {
        this.endConversationCondition = endConversationCondition;
    }

    public String getConversationName() {
        return this.conversationName;
    }

    public void setConversationName(String conversationName) {
        this.conversationName = conversationName;
    }
}

