/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class DelegatingInvocationHandler<T>
implements InvocationHandler {
    private static Log log = Logging.getLog(DelegatingInvocationHandler.class);
    private Map<Method, MethodTarget> methodCache = new HashMap<Method, MethodTarget>();
    private T delegate;

    public DelegatingInvocationHandler(T delegate) {
        this.delegate = delegate;
    }

    public T getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodTarget target = this.methodCache.get(method);
        if (target == null && !this.methodCache.containsKey(method)) {
            Map<Method, MethodTarget> map = this.methodCache;
            synchronized (map) {
                if (!this.methodCache.containsKey(method)) {
                    try {
                        target = new MethodTarget(this, this.getClass().getMethod(method.getName(), method.getParameterTypes()));
                    }
                    catch (NoSuchMethodException ex) {
                        // empty catch block
                    }
                    if (target == null) {
                        try {
                            target = new MethodTarget(this.delegate, this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()));
                        }
                        catch (NoSuchMethodException ex) {
                            // empty catch block
                        }
                    }
                    this.methodCache.put(method, target);
                } else {
                    target = this.methodCache.get(method);
                }
            }
        }
        if (target == null) {
            throw new IllegalStateException("Proxied session does not implement method " + method.getName() + " with args [" + (args == null ? null : Arrays.asList(args)) + "]");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Delegating method " + method.getName() + " with args " + (args == null ? null : Arrays.asList(args))), new Object[0]);
        }
        return target.method.invoke(target.target, args);
    }

    private class MethodTarget {
        public Method method;
        public Object target;

        public MethodTarget(Object target, Method method) {
            this.target = target;
            this.method = method;
        }
    }
}

