/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf.operations;

import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsPersistenceManager;

@Operation(id="WebUI.AddToWorklist", category="User Interface", requires="Seam", label="Push to Worklist", description="Add the input document(s) to worklist. Returns back the document(s)", aliases={"Seam.AddToWorklist"})
public class PushToWorklist {
    public static final String ID = "WebUI.AddToWorklist";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        if (OperationHelper.isSeamContextAvailable()) {
            OperationHelper.getDocumentListManager().addToWorkingList("DEFAULT", doc);
        } else {
            DocumentsListsPersistenceManager pm = new DocumentsListsPersistenceManager();
            pm.addDocumentToPersistentList(this.ctx.getPrincipal().getName(), "DEFAULT", doc);
        }
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        if (OperationHelper.isSeamContextAvailable()) {
            OperationHelper.getDocumentListManager().addToWorkingList("DEFAULT", (List)docs);
        } else {
            DocumentsListsPersistenceManager pm = new DocumentsListsPersistenceManager();
            for (DocumentModel doc : docs) {
                pm.addDocumentToPersistentList(this.ctx.getPrincipal().getName(), "DEFAULT", doc);
            }
        }
        return docs;
    }
}

