/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.update;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.AbstractTask;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.task.standalone.commands.UndeployPlaceholder;
import org.nuxeo.connect.update.task.update.RollbackOptions;
import org.nuxeo.connect.update.task.update.UpdateManager;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.w3c.dom.Element;

public class Rollback
extends AbstractCommand {
    protected static final Log log = LogFactory.getLog(Rollback.class);
    public static String ID = "rollback";
    protected String pkgId;
    protected String key;
    protected String version;
    protected boolean deleteOnExit;

    public Rollback() {
        super(ID);
    }

    public Rollback(RollbackOptions opt) {
        super(ID);
        this.pkgId = opt.pkgId;
        this.key = opt.key;
        this.version = opt.version;
        this.deleteOnExit = opt.deleteOnExit;
    }

    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.key != null) {
            writer.attr("key", this.key);
        }
        if (this.pkgId != null) {
            writer.attr("pkgId", this.pkgId);
        }
        if (this.version != null) {
            writer.attr("version", this.version);
        }
        if (this.deleteOnExit) {
            writer.attr("deleteOnExit", "true");
        }
        writer.end();
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("version");
        if (v.length() > 0) {
            this.version = v;
        }
        if ((v = element.getAttribute("pkgId")).length() > 0) {
            this.pkgId = v;
        }
        if ((v = element.getAttribute("key")).length() > 0) {
            this.key = v;
        }
        if ((v = element.getAttribute("deleteOnExit")).length() > 0) {
            this.deleteOnExit = Boolean.parseBoolean(v);
        }
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.key == null) {
            status.addError("Cannot execute command in installer. Invalid rollback syntax: key was not specified.");
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        Command undeploy;
        RollbackOptions opt;
        UpdateManager mgr = ((AbstractTask)task).getUpdateManager();
        File rollbackTarget = mgr.getRollbackTarget(opt = new RollbackOptions(task.getPackage().getId(), this.key, this.version));
        if (rollbackTarget != null && (undeploy = this.getUndeployCommand(rollbackTarget)) != null) {
            undeploy.run(task, prefs);
        }
        opt.setDeleteOnExit(this.deleteOnExit);
        mgr.rollback(opt);
        return null;
    }

    public RollbackOptions getRollbackOptions() {
        return new RollbackOptions(this.pkgId, this.key, this.version);
    }

    protected Command getUndeployCommand(File targetFile) {
        return new UndeployPlaceholder(targetFile);
    }
}

