/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.Document;
import com.lowagie.text.Meta;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;

public class RtfDestinationInfo
extends RtfDestination {
    private String elementName = "";
    private String text = "";

    public RtfDestinationInfo() {
        super(null);
    }

    public RtfDestinationInfo(RtfParser rtfParser, String string) {
        super(rtfParser);
        this.setToDefaults();
        this.elementName = string;
    }

    public void setParser(RtfParser rtfParser) {
        this.rtfParser = rtfParser;
        this.setToDefaults();
    }

    public void setElementName(String string) {
        this.elementName = string;
    }

    public boolean handleOpeningSubGroup() {
        return true;
    }

    public boolean closeDestination() {
        return true;
    }

    public boolean handleCloseGroup() {
        if (this.text.length() > 0) {
            Document document = this.rtfParser.getDocument();
            if (document != null) {
                if (this.elementName.equals("author")) {
                    document.addAuthor(this.text);
                }
                if (this.elementName.equals("title")) {
                    document.addTitle(this.text);
                }
                if (this.elementName.equals("subject")) {
                    document.addSubject(this.text);
                }
            } else {
                RtfDocument rtfDocument = this.rtfParser.getRtfDocument();
                if (rtfDocument != null) {
                    RtfInfoElement rtfInfoElement;
                    Meta meta;
                    if (this.elementName.equals("author")) {
                        meta = new Meta(this.elementName, this.text);
                        rtfInfoElement = new RtfInfoElement(rtfDocument, meta);
                        rtfDocument.getDocumentHeader().addInfoElement(rtfInfoElement);
                    }
                    if (this.elementName.equals("title")) {
                        meta = new Meta(this.elementName, this.text);
                        rtfInfoElement = new RtfInfoElement(rtfDocument, meta);
                        rtfDocument.getDocumentHeader().addInfoElement(rtfInfoElement);
                    }
                    if (this.elementName.equals("subject")) {
                        meta = new Meta(this.elementName, this.text);
                        rtfInfoElement = new RtfInfoElement(rtfDocument, meta);
                        rtfDocument.getDocumentHeader().addInfoElement(rtfInfoElement);
                    }
                }
            }
            this.setToDefaults();
        }
        return true;
    }

    public boolean handleOpenGroup() {
        return true;
    }

    public boolean handleCharacter(int n) {
        this.text = this.text + (char)n;
        return true;
    }

    public boolean handleControlWord(RtfCtrlWordData rtfCtrlWordData) {
        this.elementName = rtfCtrlWordData.ctrlWord;
        return true;
    }

    public void setToDefaults() {
        this.text = "";
    }
}

