/*
 * jQuery UI Progressbar 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/progressbar/
 *
 * Depends:
 *   jquery.ui.core.js
 *   jquery.ui.widget.js
 */
(function(A,B){A.widget("ui.progressbar",{version:"1.10.3",options:{max:100,value:0,change:null,complete:null},min:0,_create:function(){this.oldValue=this.options.value=this._constrainedValue();
this.element.addClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").attr({role:"progressbar","aria-valuemin":this.min});
this.valueDiv=A("<div class='ui-progressbar-value ui-widget-header ui-corner-left'></div>").appendTo(this.element);
this._refreshValue()
},_destroy:function(){this.element.removeClass("ui-progressbar ui-widget ui-widget-content ui-corner-all").removeAttr("role").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow");
this.valueDiv.remove()
},value:function(C){if(C===B){return this.options.value
}this.options.value=this._constrainedValue(C);
this._refreshValue()
},_constrainedValue:function(C){if(C===B){C=this.options.value
}this.indeterminate=C===false;
if(typeof C!=="number"){C=0
}return this.indeterminate?false:Math.min(this.options.max,Math.max(this.min,C))
},_setOptions:function(C){var D=C.value;
delete C.value;
this._super(C);
this.options.value=this._constrainedValue(D);
this._refreshValue()
},_setOption:function(C,D){if(C==="max"){D=Math.max(this.min,D)
}this._super(C,D)
},_percentage:function(){return this.indeterminate?100:100*(this.options.value-this.min)/(this.options.max-this.min)
},_refreshValue:function(){var D=this.options.value,C=this._percentage();
this.valueDiv.toggle(this.indeterminate||D>this.min).toggleClass("ui-corner-right",D===this.options.max).width(C.toFixed(0)+"%");
this.element.toggleClass("ui-progressbar-indeterminate",this.indeterminate);
if(this.indeterminate){this.element.removeAttr("aria-valuenow");
if(!this.overlayDiv){this.overlayDiv=A("<div class='ui-progressbar-overlay'></div>").appendTo(this.valueDiv)
}}else{this.element.attr({"aria-valuemax":this.options.max,"aria-valuenow":D});
if(this.overlayDiv){this.overlayDiv.remove();
this.overlayDiv=null
}}if(this.oldValue!==D){this.oldValue=D;
this._trigger("change")
}if(D===this.options.max){this._trigger("complete")
}}})
})(jQuery);