/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.text;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jboss.seam.text.SeamTextParserTokenTypes;

public class SeamTextParser
extends LLkParser
implements SeamTextParserTokenTypes {
    private Sanitizer sanitizer = new DefaultSanitizer();
    private Macro currentMacro;
    private Stack<Token> htmlElementStack = new Stack();
    private StringBuilder mainBuilder;
    private StringBuilder builder = this.mainBuilder = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "the end of the text", "<2>", "NULL_TREE_LOOKAHEAD", "a doublequote \\\"", "a backtick '`'", "letters or digits", "letters or digits", "a punctuation character", "a single quote '", "a slash '/'", "the escaping blackslash '\\'", "a star '*'", "a bar or pipe '|'", "a caret '^'", "a plus '+'", "an equals '='", "a hash '#'", "a tilde '~'", "an underscore '_'", "an opening square bracket '['", "a closing square bracket ']'", "QUOTE", "a closing angle bracket '>'", "an opening angle bracket '<'", "an ampersand '&'", "a space or tab", "a newline"};
    public static final BitSet _tokenSet_0 = new BitSet(SeamTextParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SeamTextParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SeamTextParser.mk_tokenSet_2());

    public void setSanitizer(Sanitizer sanitizer) {
        this.sanitizer = sanitizer;
    }

    public String toString() {
        return this.builder.toString();
    }

    private void append(String ... strings) {
        for (String string : strings) {
            this.builder.append(string);
        }
    }

    private static boolean hasMultiple(String string, char c) {
        return string.indexOf(c) != string.lastIndexOf(c);
    }

    private void beginCapture() {
        this.builder = new StringBuilder();
    }

    private String endCapture() {
        String result = this.builder.toString();
        this.builder = this.mainBuilder;
        return result;
    }

    protected String linkTag(String description, String url) {
        return "<a href=\"" + url + "\" class=\"seamTextLink\">" + description + "</a>";
    }

    protected String macroInclude(String macroName) {
        return "";
    }

    protected String macroInclude(Macro m) {
        return this.macroInclude(m.name);
    }

    protected String paragraphOpenTag() {
        return "<p class=\"seamTextPara\">\n";
    }

    protected String preformattedText(String text) {
        return "<pre class=\"seamTextPreformatted\">\n" + text + "</pre>\n";
    }

    protected String blockquoteOpenTag() {
        return "<blockquote class=\"seamTextBlockquote\">\n";
    }

    protected String headline1(String line) {
        return "<h1 class=\"seamTextHeadline1\">" + line + "</h1>";
    }

    protected String headline2(String line) {
        return "<h2 class=\"seamTextHeadline2\">" + line + "</h2>";
    }

    protected String headline3(String line) {
        return "<h3 class=\"seamTextHeadline3\">" + line + "</h3>";
    }

    protected String headline4(String line) {
        return "<h4 class=\"seamTextHeadline4\">" + line + "</h4>";
    }

    protected String orderedListOpenTag() {
        return "<ol class=\"seamTextOrderedList\">\n";
    }

    protected String orderedListItemOpenTag() {
        return "<li class=\"seamTextOrderedListItem\">";
    }

    protected String unorderedListOpenTag() {
        return "<ul class=\"seamTextUnorderedList\">\n";
    }

    protected String unorderedListItemOpenTag() {
        return "<li class=\"seamTextUnorderedListItem\">";
    }

    protected String emphasisOpenTag() {
        return "<i class=\"seamTextEmphasis\">";
    }

    protected String emphasisCloseTag() {
        return "</i>";
    }

    protected SeamTextParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected SeamTextParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public SeamTextParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final void startRule() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 27) {
            this.newline();
        }
        switch (this.LA(1)) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 26: {
                switch (this.LA(1)) {
                    case 15: {
                        this.heading();
                        while (this.LA(1) == 27) {
                            this.newline();
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 24: 
                    case 26: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.text();
                while (this.LA(1) == 15) {
                    this.heading();
                    while (this.LA(1) == 27) {
                        this.newline();
                    }
                    this.text();
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void newline() throws RecognitionException, TokenStreamException {
        Token n = null;
        n = this.LT(1);
        this.match(27);
        this.append(n.getText());
    }

    public final void heading() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 15 && _tokenSet_0.member(this.LA(2))) {
            this.h1();
        } else if (this.LA(1) == 15 && this.LA(2) == 15 && _tokenSet_0.member(this.LA(3))) {
            this.h2();
        } else if (this.LA(1) == 15 && this.LA(2) == 15 && this.LA(3) == 15 && _tokenSet_0.member(this.LA(4))) {
            this.h3();
        } else if (this.LA(1) == 15 && this.LA(2) == 15 && this.LA(3) == 15 && this.LA(4) == 15) {
            this.h4();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.newlineOrEof();
    }

    public final void text() throws RecognitionException, TokenStreamException {
        int _cnt17 = 0;
        while (true) {
            if (_tokenSet_1.member(this.LA(1))) {
                switch (this.LA(1)) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 26: {
                        this.paragraph();
                        break;
                    }
                    case 5: {
                        this.preformatted();
                        break;
                    }
                    case 4: {
                        this.blockquote();
                        break;
                    }
                    case 16: 
                    case 17: {
                        this.list();
                        break;
                    }
                    case 24: {
                        this.html();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                while (this.LA(1) == 27) {
                    this.newline();
                }
            } else {
                if (_cnt17 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt17;
        }
    }

    public final void paragraph() throws RecognitionException, TokenStreamException {
        this.append(this.paragraphOpenTag());
        int _cnt20 = 0;
        while (true) {
            if (!_tokenSet_0.member(this.LA(1))) {
                if (_cnt20 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.line();
            this.newlineOrEof();
            ++_cnt20;
        }
        this.append("</p>\n");
        this.newlineOrEof();
    }

    public final void preformatted() throws RecognitionException, TokenStreamException {
        this.match(5);
        this.beginCapture();
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: {
                    this.word();
                    continue block9;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.punctuation();
                    continue block9;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.specialChars();
                    continue block9;
                }
                case 20: 
                case 21: {
                    this.moreSpecialChars();
                    continue block9;
                }
                case 4: 
                case 23: 
                case 24: 
                case 25: {
                    this.htmlSpecialChars();
                    continue block9;
                }
                case 26: {
                    this.space();
                    continue block9;
                }
                case 27: {
                    this.newline();
                    continue block9;
                }
            }
            break;
        }
        String text = this.endCapture();
        this.append(this.preformattedText(text));
        this.match(5);
    }

    public final void blockquote() throws RecognitionException, TokenStreamException {
        this.match(4);
        this.append(this.blockquoteOpenTag());
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    continue block8;
                }
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: {
                    this.formatted();
                    continue block8;
                }
                case 5: {
                    this.preformatted();
                    continue block8;
                }
                case 27: {
                    this.newline();
                    continue block8;
                }
                case 24: {
                    this.html();
                    continue block8;
                }
                case 16: 
                case 17: {
                    this.list();
                    continue block8;
                }
            }
            break;
        }
        this.match(4);
        this.newlineOrEof();
        this.append("</blockquote>\n");
    }

    public final void list() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 17: {
                this.olist();
                break;
            }
            case 16: {
                this.ulist();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.newlineOrEof();
    }

    public final void html() throws RecognitionException, TokenStreamException {
        this.openTag();
        while (true) {
            if (this.LA(1) == 26 && (this.LA(2) == 10 || this.LA(2) == 23 || this.LA(2) == 26)) {
                this.space();
                continue;
            }
            if (this.LA(1) != 26 || this.LA(2) != 6) break;
            this.space();
            this.attribute();
        }
        switch (this.LA(1)) {
            case 23: {
                this.beforeBody();
                this.body();
                this.closeTagWithBody();
                break;
            }
            case 10: {
                this.closeTagWithNoBody();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void line() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 26: {
                this.plain();
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                this.formatted();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block11: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    continue block11;
                }
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: {
                    this.formatted();
                    continue block11;
                }
                case 5: {
                    this.preformatted();
                    continue block11;
                }
                case 4: {
                    this.quoted();
                    continue block11;
                }
                case 24: {
                    this.html();
                    continue block11;
                }
            }
            break;
        }
    }

    public final void newlineOrEof() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 27: {
                this.newline();
                break;
            }
            case 1: {
                this.match(1);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void plain() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 6: 
            case 7: {
                this.word();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                this.punctuation();
                break;
            }
            case 11: {
                this.escape();
                break;
            }
            case 26: {
                this.space();
                break;
            }
            default: {
                if (this.LA(1) == 20 && _tokenSet_2.member(this.LA(2))) {
                    this.link();
                    break;
                }
                if (this.LA(1) == 20 && this.LA(2) == 24) {
                    this.macro();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void formatted() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 19: {
                this.underline();
                break;
            }
            case 12: {
                this.emphasis();
                break;
            }
            case 13: {
                this.monospace();
                break;
            }
            case 14: {
                this.superscript();
                break;
            }
            case 18: {
                this.deleted();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void quoted() throws RecognitionException, TokenStreamException {
        this.match(4);
        this.append("<q>");
        int _cnt68 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 12: {
                    this.emphasis();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt68 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt68;
        }
        this.match(4);
        this.append("</q>");
    }

    public final void word() throws RecognitionException, TokenStreamException {
        Token an = null;
        Token uc = null;
        switch (this.LA(1)) {
            case 6: {
                an = this.LT(1);
                this.match(6);
                this.append(an.getText());
                break;
            }
            case 7: {
                uc = this.LT(1);
                this.match(7);
                this.append(uc.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void punctuation() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token sq = null;
        Token s = null;
        switch (this.LA(1)) {
            case 8: {
                p = this.LT(1);
                this.match(8);
                this.append(p.getText());
                break;
            }
            case 9: {
                sq = this.LT(1);
                this.match(9);
                this.append(sq.getText());
                break;
            }
            case 10: {
                s = this.LT(1);
                this.match(10);
                this.append(s.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void specialChars() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token b = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        switch (this.LA(1)) {
            case 12: {
                st = this.LT(1);
                this.match(12);
                this.append(st.getText());
                break;
            }
            case 13: {
                b = this.LT(1);
                this.match(13);
                this.append(b.getText());
                break;
            }
            case 14: {
                h = this.LT(1);
                this.match(14);
                this.append(h.getText());
                break;
            }
            case 15: {
                p = this.LT(1);
                this.match(15);
                this.append(p.getText());
                break;
            }
            case 16: {
                eq = this.LT(1);
                this.match(16);
                this.append(eq.getText());
                break;
            }
            case 17: {
                hh = this.LT(1);
                this.match(17);
                this.append(hh.getText());
                break;
            }
            case 11: {
                e = this.LT(1);
                this.match(11);
                this.append(e.getText());
                break;
            }
            case 18: {
                t = this.LT(1);
                this.match(18);
                this.append(t.getText());
                break;
            }
            case 19: {
                u = this.LT(1);
                this.match(19);
                this.append(u.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void moreSpecialChars() throws RecognitionException, TokenStreamException {
        Token o = null;
        Token c = null;
        switch (this.LA(1)) {
            case 20: {
                o = this.LT(1);
                this.match(20);
                this.append(o.getText());
                break;
            }
            case 21: {
                c = this.LT(1);
                this.match(21);
                this.append(c.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 23: {
                this.match(23);
                this.append("&gt;");
                break;
            }
            case 24: {
                this.match(24);
                this.append("&lt;");
                break;
            }
            case 4: {
                this.match(4);
                this.append("&quot;");
                break;
            }
            case 25: {
                this.match(25);
                this.append("&amp;");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void space() throws RecognitionException, TokenStreamException {
        Token s = null;
        s = this.LT(1);
        this.match(26);
        this.append(s.getText());
    }

    public final void escape() throws RecognitionException, TokenStreamException {
        Token b = null;
        this.match(11);
        switch (this.LA(1)) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.specialChars();
                break;
            }
            case 20: 
            case 21: {
                this.moreSpecialChars();
                break;
            }
            case 22: {
                this.evenMoreSpecialChars();
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 25: {
                this.htmlSpecialChars();
                break;
            }
            case 5: {
                b = this.LT(1);
                this.match(5);
                this.append(b.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void link() throws RecognitionException, TokenStreamException {
        Token gt = null;
        this.match(20);
        this.beginCapture();
        block6: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: {
                    this.word();
                    continue block6;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.punctuation();
                    continue block6;
                }
                case 11: {
                    this.escape();
                    continue block6;
                }
                case 26: {
                    this.space();
                    continue block6;
                }
            }
            break;
        }
        String text = this.endCapture();
        this.match(16);
        gt = this.LT(1);
        this.match(23);
        this.beginCapture();
        this.attributeValue();
        String link = this.endCapture();
        this.sanitizer.validateLinkTagURI(gt, link);
        this.append(this.linkTag(text, link));
        this.match(21);
    }

    public final void macro() throws RecognitionException, TokenStreamException {
        Token mn = null;
        this.match(20);
        this.match(24);
        this.match(16);
        mn = this.LT(1);
        this.match(6);
        this.currentMacro = new Macro(mn.getText());
        while (this.LA(1) == 20) {
            this.macroParam();
        }
        this.match(21);
        this.append(this.macroInclude(this.currentMacro));
        this.currentMacro = null;
    }

    public final void underline() throws RecognitionException, TokenStreamException {
        this.match(19);
        this.append("<u>");
        int _cnt56 = 0;
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 12: {
                    this.emphasis();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt56 >= 1) break block8;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt56;
        }
        this.match(19);
        this.append("</u>");
    }

    public final void emphasis() throws RecognitionException, TokenStreamException {
        this.match(12);
        this.append(this.emphasisOpenTag());
        int _cnt53 = 0;
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt53 >= 1) break block8;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt53;
        }
        this.match(12);
        this.append(this.emphasisCloseTag());
    }

    public final void monospace() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        this.match(13);
        this.append("<tt>");
        int _cnt59 = 0;
        block16: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: {
                    this.word();
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    this.punctuation();
                    break;
                }
                case 26: {
                    this.space();
                    break;
                }
                case 12: {
                    st = this.LT(1);
                    this.match(12);
                    this.append(st.getText());
                    break;
                }
                case 14: {
                    h = this.LT(1);
                    this.match(14);
                    this.append(h.getText());
                    break;
                }
                case 15: {
                    p = this.LT(1);
                    this.match(15);
                    this.append(p.getText());
                    break;
                }
                case 16: {
                    eq = this.LT(1);
                    this.match(16);
                    this.append(eq.getText());
                    break;
                }
                case 17: {
                    hh = this.LT(1);
                    this.match(17);
                    this.append(hh.getText());
                    break;
                }
                case 11: {
                    e = this.LT(1);
                    this.match(11);
                    this.append(e.getText());
                    break;
                }
                case 18: {
                    t = this.LT(1);
                    this.match(18);
                    this.append(t.getText());
                    break;
                }
                case 19: {
                    u = this.LT(1);
                    this.match(19);
                    this.append(u.getText());
                    break;
                }
                case 20: 
                case 21: {
                    this.moreSpecialChars();
                    break;
                }
                case 4: 
                case 23: 
                case 24: 
                case 25: {
                    this.htmlSpecialChars();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt59 >= 1) break block16;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt59;
        }
        this.match(13);
        this.append("</tt>");
    }

    public final void superscript() throws RecognitionException, TokenStreamException {
        this.match(14);
        this.append("<sup>");
        int _cnt62 = 0;
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 12: {
                    this.emphasis();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 18: {
                    this.deleted();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt62 >= 1) break block8;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt62;
        }
        this.match(14);
        this.append("</sup>");
    }

    public final void deleted() throws RecognitionException, TokenStreamException {
        this.match(18);
        this.append("<del>");
        int _cnt65 = 0;
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    break;
                }
                case 12: {
                    this.emphasis();
                    break;
                }
                case 19: {
                    this.underline();
                    break;
                }
                case 13: {
                    this.monospace();
                    break;
                }
                case 14: {
                    this.superscript();
                    break;
                }
                case 27: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt65 >= 1) break block8;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt65;
        }
        this.match(18);
        this.append("</del>");
    }

    public final void evenMoreSpecialChars() throws RecognitionException, TokenStreamException {
        Token q = null;
        q = this.LT(1);
        this.match(22);
        this.append(q.getText());
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        Token an = null;
        Token p = null;
        Token s = null;
        try {
            block10: while (true) {
                switch (this.LA(1)) {
                    case 25: {
                        this.match(25);
                        this.append("&amp;");
                        continue block10;
                    }
                    case 6: {
                        an = this.LT(1);
                        this.match(6);
                        this.append(an.getText());
                        continue block10;
                    }
                    case 8: {
                        p = this.LT(1);
                        this.match(8);
                        this.append(p.getText());
                        continue block10;
                    }
                    case 10: {
                        s = this.LT(1);
                        this.match(10);
                        this.append(s.getText());
                        continue block10;
                    }
                    case 26: {
                        this.space();
                        continue block10;
                    }
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        this.specialChars();
                        continue block10;
                    }
                }
                break;
            }
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void macroParam() throws RecognitionException, TokenStreamException {
        Token pn = null;
        this.match(20);
        pn = this.LT(1);
        this.match(6);
        this.match(16);
        this.beginCapture();
        this.macroParamValue();
        String pv = this.endCapture();
        this.currentMacro.params.put(pn.getText(), pv);
        this.match(21);
    }

    public final void macroParamValue() throws RecognitionException, TokenStreamException {
        Token amp = null;
        Token dq = null;
        Token sq = null;
        Token an = null;
        Token p = null;
        Token s = null;
        Token lt = null;
        Token gt = null;
        block12: while (true) {
            switch (this.LA(1)) {
                case 25: {
                    amp = this.LT(1);
                    this.match(25);
                    this.append(amp.getText());
                    continue block12;
                }
                case 4: {
                    dq = this.LT(1);
                    this.match(4);
                    this.append(dq.getText());
                    continue block12;
                }
                case 9: {
                    sq = this.LT(1);
                    this.match(9);
                    this.append(sq.getText());
                    continue block12;
                }
                case 6: {
                    an = this.LT(1);
                    this.match(6);
                    this.append(an.getText());
                    continue block12;
                }
                case 8: {
                    p = this.LT(1);
                    this.match(8);
                    this.append(p.getText());
                    continue block12;
                }
                case 10: {
                    s = this.LT(1);
                    this.match(10);
                    this.append(s.getText());
                    continue block12;
                }
                case 24: {
                    lt = this.LT(1);
                    this.match(24);
                    this.append(lt.getText());
                    continue block12;
                }
                case 23: {
                    gt = this.LT(1);
                    this.match(23);
                    this.append(gt.getText());
                    continue block12;
                }
                case 26: {
                    this.space();
                    continue block12;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    this.specialChars();
                    continue block12;
                }
            }
            break;
        }
    }

    public final void h1() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.beginCapture();
        this.line();
        String headline = this.endCapture();
        this.append(this.headline1(headline.trim()));
    }

    public final void h2() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.match(15);
        this.beginCapture();
        this.line();
        String headline = this.endCapture();
        this.append(this.headline2(headline.trim()));
    }

    public final void h3() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.match(15);
        this.match(15);
        this.beginCapture();
        this.line();
        String headline = this.endCapture();
        this.append(this.headline3(headline.trim()));
    }

    public final void h4() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.match(15);
        this.match(15);
        this.match(15);
        this.beginCapture();
        this.line();
        String headline = this.endCapture();
        this.append(this.headline4(headline.trim()));
    }

    public final void olist() throws RecognitionException, TokenStreamException {
        this.append(this.orderedListOpenTag());
        int _cnt79 = 0;
        while (true) {
            if (this.LA(1) != 17) {
                if (_cnt79 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.olistLine();
            this.newlineOrEof();
            ++_cnt79;
        }
        this.append("</ol>\n");
    }

    public final void ulist() throws RecognitionException, TokenStreamException {
        this.append(this.unorderedListOpenTag());
        int _cnt83 = 0;
        while (true) {
            if (this.LA(1) != 16) {
                if (_cnt83 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.ulistLine();
            this.newlineOrEof();
            ++_cnt83;
        }
        this.append("</ul>\n");
    }

    public final void olistLine() throws RecognitionException, TokenStreamException {
        this.match(17);
        this.append(this.orderedListItemOpenTag());
        this.line();
        this.append("</li>");
    }

    public final void ulistLine() throws RecognitionException, TokenStreamException {
        this.match(16);
        this.append(this.unorderedListItemOpenTag());
        this.line();
        this.append("</li>");
    }

    public final void openTag() throws RecognitionException, TokenStreamException {
        Token name = null;
        try {
            this.match(24);
            name = this.LT(1);
            this.match(6);
            this.htmlElementStack.push(name);
            this.sanitizer.validateHtmlElement(name);
            this.append("<");
            this.append(name.getText());
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void attribute() throws RecognitionException, TokenStreamException {
        Token att = null;
        try {
            att = this.LT(1);
            this.match(6);
            while (this.LA(1) == 26) {
                this.space();
            }
            this.match(16);
            while (this.LA(1) == 26) {
                this.space();
            }
            this.match(4);
            this.sanitizer.validateHtmlAttribute(this.htmlElementStack.peek(), att);
            this.append(att.getText());
            this.append("=\"");
            this.beginCapture();
            this.attributeValue();
            String attValue = this.endCapture();
            this.sanitizer.validateHtmlAttributeValue(this.htmlElementStack.peek(), att, attValue);
            this.append(attValue);
            this.match(4);
            this.append("\"");
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void beforeBody() throws RecognitionException, TokenStreamException {
        try {
            this.match(23);
            this.append(">");
        }
        catch (RecognitionException ex) {
            if (this.htmlElementStack.isEmpty()) {
                throw ex;
            }
            Token tok = this.htmlElementStack.peek();
            if (tok != null) {
                throw new HtmlRecognitionException(tok, ex);
            }
            throw ex;
        }
    }

    public final void body() throws RecognitionException, TokenStreamException {
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 20: 
                case 26: {
                    this.plain();
                    continue block8;
                }
                case 12: 
                case 13: 
                case 14: 
                case 18: 
                case 19: {
                    this.formatted();
                    continue block8;
                }
                case 5: {
                    this.preformatted();
                    continue block8;
                }
                case 4: {
                    this.quoted();
                    continue block8;
                }
                case 16: 
                case 17: {
                    this.list();
                    continue block8;
                }
                case 27: {
                    this.newline();
                    continue block8;
                }
            }
            if (this.LA(1) != 24 || this.LA(2) != 6) break;
            this.html();
        }
    }

    public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
        Token name = null;
        this.match(24);
        this.match(10);
        name = this.LT(1);
        this.match(6);
        this.match(23);
        this.append("</");
        this.append(name.getText());
        this.append(">");
        this.htmlElementStack.pop();
    }

    public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
        this.match(10);
        this.match(23);
        this.append("/>");
        this.htmlElementStack.pop();
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{68976576L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{85950448L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{67178432L, 0L};
        return data;
    }

    public static class DefaultSanitizer
    implements Sanitizer {
        public final Pattern REGEX_VALID_CSS_STRING1 = Pattern.compile("^([-:,;#%.\\sa-zA-Z0-9!]|\\w-\\w|'[\\s\\w]+'|\"[\\s\\w]+\"|\\([\\d,\\s]+\\))*$");
        public final Pattern REGEX_VALID_CSS_STRING2 = Pattern.compile("^(\\s*[-\\w]+\\s*:\\s*[^:;]*(;|$))*$");
        public final Pattern REGEX_VALID_CSS_VALUE = Pattern.compile("^(#[0-9a-f]{3,6}|rgb\\(\\d{1,3}%?,\\d{1,3}%?,?\\d{1,3}%?\\)?|-?\\d{0,2}\\.?\\d{0,2}(cm|em|ex|in|mm|pc|pt|px|%|,|\\))?)$");
        public final Pattern REGEX_INVALID_CSS_URL = Pattern.compile("url\\s*\\(\\s*[^\\s)]+?\\s*\\)\\s*");
        protected Set<String> acceptableElements = new HashSet<String>(Arrays.asList("a", "abbr", "acronym", "address", "area", "b", "bdo", "big", "blockquote", "br", "caption", "center", "cite", "code", "col", "colgroup", "dd", "del", "dfn", "dir", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "kbd", "label", "legend", "li", "map", "menu", "ol", "p", "pre", "q", "s", "samp", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "tt", "u", "ul", "var", "wbr"));
        protected Set<String> mathmlElements = new HashSet<String>(Arrays.asList("maction", "math", "merror", "mfrac", "mi", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mprescripts", "mroot", "mrow", "mspace", "msqrt", "mstyle", "msub", "msubsup", "msup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "none"));
        protected Set<String> svgElements = new HashSet<String>(Arrays.asList("a", "animate", "animateColor", "animateMotion", "animateTransform", "circle", "defs", "desc", "ellipse", "font-face", "font-face-name", "font-face-src", "g", "glyph", "hkern", "image", "line", "linearGradient", "marker", "metadata", "missing-glyph", "mpath", "path", "polygon", "polyline", "radialGradient", "rect", "set", "stop", "svg", "switch", "text", "title", "tspan", "use"));
        protected Set<String> acceptableAttributes = new HashSet<String>(Arrays.asList("abbr", "accept", "accept-charset", "accesskey", "action", "align", "alt", "axis", "border", "cellpadding", "cellspacing", "char", "charoff", "charset", "checked", "cite", "class", "clear", "color", "cols", "colspan", "compact", "coords", "datetime", "dir", "disabled", "enctype", "for", "frame", "headers", "height", "href", "hreflang", "hspace", "id", "ismap", "label", "lang", "longdesc", "maxlength", "media", "method", "multiple", "name", "nohref", "noshade", "nowrap", "prompt", "readonly", "rel", "rev", "rows", "rowspan", "rules", "scope", "selected", "shape", "size", "span", "src", "start", "style", "summary", "tabindex", "target", "title", "type", "usemap", "valign", "value", "vspace", "width", "xml:lang"));
        protected Set<String> mathmlAttributes = new HashSet<String>(Arrays.asList("actiontype", "align", "columnalign", "columnalign", "columnalign", "columnlines", "columnspacing", "columnspan", "depth", "display", "displaystyle", "equalcolumns", "equalrows", "fence", "fontstyle", "fontweight", "frame", "height", "linethickness", "lspace", "mathbackground", "mathcolor", "mathvariant", "mathvariant", "maxsize", "minsize", "other", "rowalign", "rowalign", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "scriptlevel", "selection", "separator", "stretchy", "width", "width", "xlink:href", "xlink:show", "xlink:type", "xmlns", "xmlns:xlink"));
        protected Set<String> svgAttributes = new HashSet<String>(Arrays.asList("accent-height", "accumulate", "additive", "alphabetic", "arabic-form", "ascent", "attributeName", "attributeType", "baseProfile", "bbox", "begin", "by", "calcMode", "cap-height", "class", "color", "color-rendering", "content", "cx", "cy", "d", "descent", "display", "dur", "dx", "dy", "end", "fill", "fill-rule", "font-family", "font-size", "font-stretch", "font-style", "font-variant", "font-weight", "from", "fx", "fy", "g1", "g2", "glyph-name", "gradientUnits", "hanging", "height", "horiz-adv-x", "horiz-origin-x", "id", "ideographic", "k", "keyPoints", "keySplines", "keyTimes", "lang", "marker-end", "marker-mid", "marker-start", "markerHeight", "markerUnits", "markerWidth", "mathematical", "max", "min", "name", "offset", "opacity", "orient", "origin", "overline-position", "overline-thickness", "panose-1", "path", "pathLength", "points", "preserveAspectRatio", "r", "refX", "refY", "repeatCount", "repeatDur", "requiredExtensions", "requiredFeatures", "restart", "rotate", "rx", "ry", "slope", "stemh", "stemv", "stop-color", "stop-opacity", "strikethrough-position", "strikethrough-thickness", "stroke", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke-width", "systemLanguage", "target", "text-anchor", "to", "transform", "type", "u1", "u2", "underline-position", "underline-thickness", "unicode", "unicode-range", "units-per-em", "values", "version", "viewBox", "visibility", "width", "widths", "x", "x-height", "x1", "x2", "xlink:actuate", "xlink:arcrole", "xlink:href", "xlink:role", "xlink:show", "xlink:title", "xlink:type", "xml:base", "xml:lang", "xml:space", "xmlns", "xmlns:xlink", "y", "y1", "y2", "zoomAndPan"));
        protected Set<String> styleProperties = new HashSet<String>(Arrays.asList("azimuth", "background", "background-attachment", "background-color", "background-image", "background-position", "background-repeat", "border", "border-bottom", "border-bottom-color", "border-bottom-style", "border-bottom-width", "border-collapse", "border-color", "border-left", "border-left-color", "border-left-style", "border-left-width", "border-right", "border-right-color", "border-right-style", "border-right-width", "border-spacing", "border-style", "border-top", "border-top-color", "border-top-style", "border-top-width", "border-width", "clear", "color", "cursor", "direction", "display", "elevation", "float", "font", "font-family", "font-size", "font-style", "font-variant", "font-weight", "height", "letter-spacing", "line-height", "margin", "margin-bottom", "margin-left", "margin-right", "margin-top", "max-height", "max-width", "min-height", "min-width", "overflow", "padding", "padding-bottom", "padding-left", "padding-right", "padding-top", "pause", "pause-after", "pause-before", "pitch", "pitch-range", "richness", "speak", "speak-header", "speak-numeral", "speak-punctuation", "speech-rate", "stress", "text-align", "text-decoration", "text-indent", "unicode-bidi", "vertical-align", "voice-family", "volume", "white-space", "width"));
        protected Set<String> stylePropertiesValues = new HashSet<String>(Arrays.asList("aqua", "auto", "baseline", "black", "block", "blue", "bold", "both", "bottom", "brown", "center", "collapse", "dashed", "dotted", "fuchsia", "gray", "green", "inherit", "italic", "left", "length", "lime", "maroon", "medium", "middle", "navy", "none", "normal", "nowrap", "olive", "percentage", "pointer", "purple", "red", "right", "silver", "solid", "sub", "super", "teal", "text-bottom", "text-top", "top", "transparent", "underline", "white", "yellow"));
        protected Set<String> svgStyleProperties = new HashSet<String>(Arrays.asList("fill", "fill-opacity", "fill-rule", "stroke", "stroke-linecap", "stroke-linejoin", "stroke-opacity", "stroke-width"));
        protected Set<String> attributesWhoseValueIsAURI = new HashSet<String>(Arrays.asList("action", "cite", "href", "longdesc", "src", "xlink:href", "xml:base"));
        protected Set<String> uriSchemes = new HashSet<String>(Arrays.asList("afs", "aim", "callto", "ed2k", "feed", "ftp", "gopher", "http", "https", "irc", "mailto", "news", "nntp", "rsync", "rtsp", "sftp", "ssh", "tag", "tel", "telnet", "urn", "webcal", "wtai", "xmpp"));

        @Override
        public void validateLinkTagURI(Token element, String uri) throws SemanticException {
            if (!this.validateURI(uri)) {
                throw this.createSemanticException("Invalid URI", element);
            }
        }

        @Override
        public void validateHtmlElement(Token element) throws SemanticException {
            String elementName = element.getText().toLowerCase();
            if (!(this.acceptableElements.contains(elementName) || this.svgElements.contains(elementName) || this.mathmlElements.contains(elementName))) {
                throw this.createSemanticException(this.getInvalidElementMessage(elementName), element);
            }
        }

        @Override
        public void validateHtmlAttribute(Token element, Token attribute) throws SemanticException {
            String elementName = element.getText().toLowerCase();
            String attributeName = attribute.getText().toLowerCase();
            if (!(this.acceptableAttributes.contains(attributeName) || this.svgAttributes.contains(attributeName) || this.mathmlAttributes.contains(attributeName))) {
                throw this.createSemanticException(this.getInvalidAttributeMessage(elementName, attributeName), element);
            }
        }

        @Override
        public void validateHtmlAttributeValue(Token element, Token attribute, String attributeValue) throws SemanticException {
            if (attributeValue == null || attributeValue.length() == 0) {
                return;
            }
            String elementName = element.getText().toLowerCase();
            String attributeName = attribute.getText().toLowerCase();
            if (this.attributesWhoseValueIsAURI.contains(attributeName) && !this.validateURI(attributeValue)) {
                throw this.createSemanticException(this.getInvalidURIMessage(attributeValue), element);
            }
            if (attributeName.equals("style")) {
                String[] cssProperties;
                if (!this.REGEX_VALID_CSS_STRING1.matcher(attributeValue).matches() || !this.REGEX_VALID_CSS_STRING2.matcher(attributeValue).matches()) {
                    throw this.createSemanticException(this.getInvalidAttributeValueMessage(elementName, attributeName, attributeValue), element);
                }
                for (String cssProperty : cssProperties = attributeValue.split(";")) {
                    String propertyValue;
                    if (!cssProperty.contains(":")) {
                        throw this.createSemanticException(this.getInvalidAttributeValueMessage(elementName, attributeName, attributeValue), element);
                    }
                    String[] property = cssProperty.split(":");
                    String propertyName = property[0].trim();
                    String string = propertyValue = property.length == 2 ? property[1].trim() : null;
                    if (!this.styleProperties.contains(propertyName) && !this.svgStyleProperties.contains(propertyName)) {
                        throw this.createSemanticException(this.getInvalidAttributeValueMessage(elementName, attributeName, attributeValue), element);
                    }
                    if (propertyValue == null || this.stylePropertiesValues.contains(propertyValue) || this.REGEX_VALID_CSS_VALUE.matcher(propertyValue).matches()) continue;
                    throw this.createSemanticException(this.getInvalidAttributeValueMessage(elementName, attributeName, attributeValue), element);
                }
            }
        }

        protected boolean validateURI(String uri) {
            URI parsedURI;
            if (uri.startsWith("/")) {
                return true;
            }
            try {
                parsedURI = new URI(uri);
            }
            catch (URISyntaxException ex) {
                return false;
            }
            return this.uriSchemes.contains(parsedURI.getScheme());
        }

        @Override
        public String getInvalidURIMessage(String uri) {
            return "invalid URI";
        }

        @Override
        public String getInvalidElementMessage(String elementName) {
            return "invalid element '" + elementName + "'";
        }

        @Override
        public String getInvalidAttributeMessage(String elementName, String attributeName) {
            return "invalid attribute '" + attributeName + "' for element '" + elementName + "'";
        }

        @Override
        public String getInvalidAttributeValueMessage(String elementName, String attributeName, String value) {
            return "invalid value of attribute '" + attributeName + "' for element '" + elementName + "'";
        }

        public SemanticException createSemanticException(String message, Token element) {
            return new SemanticException(message, element.getFilename(), element.getLine(), element.getColumn());
        }
    }

    public static interface Sanitizer {
        public void validateLinkTagURI(Token var1, String var2) throws SemanticException;

        public void validateHtmlElement(Token var1) throws SemanticException;

        public void validateHtmlAttribute(Token var1, Token var2) throws SemanticException;

        public void validateHtmlAttributeValue(Token var1, Token var2, String var3) throws SemanticException;

        public String getInvalidURIMessage(String var1);

        public String getInvalidElementMessage(String var1);

        public String getInvalidAttributeMessage(String var1, String var2);

        public String getInvalidAttributeValueMessage(String var1, String var2, String var3);
    }

    public class HtmlRecognitionException
    extends RecognitionException {
        Token openingElement;
        RecognitionException wrappedException;

        public HtmlRecognitionException(Token openingElement, RecognitionException wrappedException) {
            this.openingElement = openingElement;
            this.wrappedException = wrappedException;
        }

        public Token getOpeningElement() {
            return this.openingElement;
        }

        public String getMessage() {
            return this.wrappedException.getMessage();
        }

        public Throwable getCause() {
            return this.wrappedException;
        }
    }

    public class Macro {
        public String name;
        public SortedMap<String, String> params = new TreeMap<String, String>();

        public Macro(String name) {
            this.name = name;
        }
    }
}

