/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.ejb.EJBException;
import javax.ejb.Remove;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.Synchronization;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.LocalEjbSynchronizations;
import org.jboss.seam.transaction.SynchronizationRegistry;

@Stateful
@Name(value="org.jboss.seam.transaction.synchronizations")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10, dependencies={"org.jboss.seam.transaction.ejbTransaction"})
@BypassInterceptors
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
public class EjbSynchronizations
implements LocalEjbSynchronizations,
SessionSynchronization {
    private static final LogProvider log = Logging.getLogProvider(EjbSynchronizations.class);
    protected LinkedList<SynchronizationRegistry> synchronizations = new LinkedList();
    protected LinkedList<SynchronizationRegistry> committing = new LinkedList();

    public void afterBegin() {
        log.debug("afterBegin");
        this.synchronizations.addLast(new SynchronizationRegistry());
    }

    public void beforeCompletion() throws EJBException, RemoteException {
        log.debug("beforeCompletion");
        SynchronizationRegistry sync = this.synchronizations.removeLast();
        sync.beforeTransactionCompletion();
        this.committing.addLast(sync);
    }

    public void afterCompletion(boolean success) throws EJBException, RemoteException {
        log.debug("afterCompletion");
        if (this.committing.isEmpty()) {
            if (success) {
                throw new IllegalStateException("beforeCompletion was never called");
            }
            this.synchronizations.removeLast().afterTransactionCompletion(false);
        } else {
            this.committing.removeFirst().afterTransactionCompletion(success);
        }
    }

    @Override
    public boolean isAwareOfContainerTransactions() {
        return true;
    }

    @Override
    public void afterTransactionBegin() {
    }

    @Override
    public void afterTransactionCommit(boolean success) {
    }

    @Override
    public void afterTransactionRollback() {
    }

    @Override
    public void beforeTransactionCommit() {
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        this.synchronizations.getLast().registerSynchronization(sync);
    }

    @Override
    @Remove
    public void destroy() {
    }
}

