/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractChart;
import org.richfaces.component.AbstractLegend;
import org.richfaces.component.AbstractPoint;
import org.richfaces.component.AbstractSeries;
import org.richfaces.component.AbstractXAxis;
import org.richfaces.component.AbstractYAxis;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONException;
import org.richfaces.json.JSONObject;
import org.richfaces.model.ChartDataModel;
import org.richfaces.model.NumberChartDataModel;
import org.richfaces.model.PlotClickEvent;
import org.richfaces.model.RawJSONString;
import org.richfaces.model.StringChartDataModel;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;

public abstract class ChartRendererBase
extends RendererBase {
    public static final String RENDERER_TYPE = "org.richfaces.ChartRenderer";
    private static final String X_VALUE = "x";
    private static final String Y_VALUE = "y";
    private static final String POINT_INDEX = "dataIndex";
    private static final String SERIES_INDEX = "seriesIndex";
    private static final String EVENT_TYPE = "name";
    private static final String PLOT_CLICK_TYPE = "plotclick";

    public static JSONObject addAttribute(JSONObject obj, String key, Object value) throws IOException {
        try {
            if (value != null && !value.equals("")) {
                obj.put(key, value);
            }
        }
        catch (JSONException ex) {
            throw new IOException("JSONObject put failed.");
        }
        return obj;
    }

    public JSONObject getOpts(FacesContext context, UIComponent component) throws IOException {
        JSONObject obj = new JSONObject();
        ChartRendererBase.addAttribute(obj, "zoom", component.getAttributes().get("zoom"));
        ChartRendererBase.addAttribute(obj, "charttype", component.getAttributes().get("charttype"));
        ChartRendererBase.addAttribute(obj, "xtype", component.getAttributes().get("xtype"));
        ChartRendererBase.addAttribute(obj, "ytype", component.getAttributes().get("ytype"));
        ChartRendererBase.addAttribute(obj, "serverSideListener", component.getAttributes().get("serverSideListener"));
        JSONObject xaxis = new JSONObject();
        ChartRendererBase.addAttribute(xaxis, "min", component.getAttributes().get("xmin"));
        ChartRendererBase.addAttribute(xaxis, "max", component.getAttributes().get("xmax"));
        ChartRendererBase.addAttribute(xaxis, "autoscaleMargin", component.getAttributes().get("xpad"));
        ChartRendererBase.addAttribute(xaxis, "axisLabel", component.getAttributes().get("xlabel"));
        ChartRendererBase.addAttribute(xaxis, "format", component.getAttributes().get("xformat"));
        JSONObject yaxis = new JSONObject();
        ChartRendererBase.addAttribute(yaxis, "min", component.getAttributes().get("ymin"));
        ChartRendererBase.addAttribute(yaxis, "max", component.getAttributes().get("ymax"));
        ChartRendererBase.addAttribute(yaxis, "autoscaleMargin", component.getAttributes().get("ypad"));
        ChartRendererBase.addAttribute(yaxis, "axisLabel", component.getAttributes().get("ylabel"));
        ChartRendererBase.addAttribute(yaxis, "format", component.getAttributes().get("yformat"));
        JSONObject legend = new JSONObject();
        ChartRendererBase.addAttribute(legend, "position", component.getAttributes().get("position"));
        ChartRendererBase.addAttribute(legend, "sorted", component.getAttributes().get("sorting"));
        ChartRendererBase.addAttribute(obj, "xaxis", xaxis);
        ChartRendererBase.addAttribute(obj, "yaxis", yaxis);
        ChartRendererBase.addAttribute(obj, "legend", legend);
        return obj;
    }

    public void doDecode(FacesContext context, UIComponent component) {
        if (!component.isRendered()) {
            return;
        }
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.get(component.getClientId(context)) != null) {
            String xParam = (String)requestParameterMap.get(this.getFieldId(component, X_VALUE));
            String yParam = (String)requestParameterMap.get(this.getFieldId(component, Y_VALUE));
            String pointIndexParam = (String)requestParameterMap.get(this.getFieldId(component, POINT_INDEX));
            String eventTypeParam = (String)requestParameterMap.get(this.getFieldId(component, EVENT_TYPE));
            String seriesIndexParam = (String)requestParameterMap.get(this.getFieldId(component, SERIES_INDEX));
            try {
                if (PLOT_CLICK_TYPE.equals(eventTypeParam)) {
                    double y = Double.parseDouble(yParam);
                    int seriesIndex = Integer.parseInt(seriesIndexParam);
                    int pointIndex = Integer.parseInt(pointIndexParam);
                    String x = xParam;
                    new PlotClickEvent(component, seriesIndex, pointIndex, x, y).queue();
                }
            }
            catch (NumberFormatException ex) {
                throw new FacesException("Cannot convert request parmeters", (Throwable)ex);
            }
        }
    }

    public JSONArray getChartData(FacesContext ctx, UIComponent component) {
        return (JSONArray)component.getAttributes().get("chartData");
    }

    public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        boolean anyServerSideListener;
        AbstractChart chart = (AbstractChart)component;
        VisitChart visitCallback = new VisitChart(chart);
        chart.visitTree(VisitContext.createVisitContext((FacesContext)FacesContext.getCurrentInstance()), visitCallback);
        component.getAttributes().put("chartData", visitCallback.getData());
        if (!visitCallback.isDataEmpty()) {
            component.getAttributes().put("charttype", visitCallback.getChartType());
            component.getAttributes().put("xtype", this.axisDataTypeToString(visitCallback.getKeyType()));
            component.getAttributes().put("ytype", this.axisDataTypeToString(visitCallback.getValType()));
        }
        boolean bl = anyServerSideListener = chart.getPlotClickListener() != null;
        if (!anyServerSideListener) {
            List<MethodExpression> listeners = visitCallback.getParticularSeriesListeners();
            for (MethodExpression methodExpression : listeners) {
                if (methodExpression == null) continue;
                anyServerSideListener = true;
                break;
            }
        }
        component.getAttributes().put("serverSideListener", anyServerSideListener);
        component.getAttributes().put("handlers", visitCallback.getSeriesSpecificHandlers());
        component.getAttributes().put("particularSeriesListeners", visitCallback.getParticularSeriesListeners());
    }

    public String axisDataTypeToString(Class c) {
        if (c == String.class) {
            return "string";
        }
        if (c == Number.class) {
            return "number";
        }
        if (c == Date.class) {
            return "date";
        }
        return c.getName();
    }

    public JSONObject getParticularSeriesHandler(FacesContext context, UIComponent component) {
        return (JSONObject)component.getAttributes().get("handlers");
    }

    public String getFieldId(UIComponent component, String attribute) {
        return component.getClientId() + attribute;
    }

    class VisitSeries
    implements VisitCallback {
        private ChartDataModel model = null;
        private final ChartDataModel.ChartType type;

        public VisitSeries(ChartDataModel.ChartType type) {
            this.type = type;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public VisitResult visit(VisitContext context, UIComponent target) {
            if (!(target instanceof AbstractPoint)) return VisitResult.ACCEPT;
            AbstractPoint p = (AbstractPoint)target;
            Object x = p.getX();
            Object y = p.getY();
            if (this.model == null) {
                if (x instanceof Number && y instanceof Number) {
                    this.model = new NumberChartDataModel(this.type);
                } else {
                    if (!(x instanceof String) || !(y instanceof Number)) throw new IllegalArgumentException("Not supported type");
                    this.model = new StringChartDataModel(this.type);
                }
            }
            if (!this.model.getKeyType().isAssignableFrom(x.getClass()) || !this.model.getValueType().isAssignableFrom(y.getClass())) throw new IllegalArgumentException("Not supported types " + x.getClass() + " " + y.getClass() + " for " + this.model.getClass());
            if (x instanceof Number && y instanceof Number) {
                this.model.put(x, y);
                return VisitResult.ACCEPT;
            } else {
                if (!(x instanceof String) || !(y instanceof Number)) throw new IllegalArgumentException("Not supported types " + x.getClass() + " " + y.getClass() + " for " + this.model.getClass());
                this.model.put(x, y);
            }
            return VisitResult.ACCEPT;
        }

        public ChartDataModel getModel() {
            return this.model;
        }
    }

    class VisitChart
    implements VisitCallback {
        private final AbstractChart chart;
        private final JSONArray data;
        private final JSONObject particularSeriesHandlers;
        private final JSONArray plotClickHandlers;
        private final JSONArray plothoverHandlers;
        private final List<MethodExpression> particularSeriesListeners;
        private ChartDataModel.ChartType chartType;
        private Class keyType;
        private Class valType;
        private final RenderKitUtils.ScriptHashVariableWrapper eventWrapper = RenderKitUtils.ScriptHashVariableWrapper.eventHandler;
        private boolean nodata = true;

        public VisitChart(AbstractChart ch) {
            this.chart = ch;
            this.chartType = null;
            this.data = new JSONArray();
            this.particularSeriesHandlers = new JSONObject();
            this.plotClickHandlers = new JSONArray();
            this.plothoverHandlers = new JSONArray();
            this.particularSeriesListeners = new LinkedList<MethodExpression>();
            try {
                ChartRendererBase.addAttribute(this.particularSeriesHandlers, "onplotclick", this.plotClickHandlers);
                ChartRendererBase.addAttribute(this.particularSeriesHandlers, "onplothover", this.plothoverHandlers);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        }

        private void copyAttr(UIComponent src, UIComponent target, String prefix, String attr) {
            Object val = src.getAttributes().get(attr);
            if (val != null) {
                target.getAttributes().put(prefix + attr, val);
            }
        }

        private void copyAttrs(UIComponent src, UIComponent target, String prefix, List<String> attrs) {
            for (String attr : attrs) {
                this.copyAttr(src, target, prefix, attr);
            }
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (target instanceof AbstractLegend) {
                this.copyAttrs(target, (UIComponent)this.chart, "", Arrays.asList("position", "sorting"));
            } else if (target instanceof AbstractSeries) {
                AbstractSeries s = (AbstractSeries)target;
                ChartDataModel model = s.getData();
                this.particularSeriesListeners.add(s.getPlotClickListener());
                HashMap optMap = new HashMap();
                RenderKitUtils.Attributes seriesEvents = RenderKitUtils.attributes().generic("onplothover", "onplothover", new String[]{"plothover"}).generic("onplotclick", "onplotclick", new String[]{ChartRendererBase.PLOT_CLICK_TYPE});
                RenderKitUtils.addToScriptHash(optMap, (FacesContext)context.getFacesContext(), (UIComponent)target, (RenderKitUtils.Attributes)seriesEvents, (RenderKitUtils.ScriptHashVariableWrapper)RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
                if (optMap.get("onplotclick") != null) {
                    this.plotClickHandlers.put((Object)new RawJSONString(optMap.get("onplotclick").toString()));
                } else {
                    this.plotClickHandlers.put((Object)s.getOnplotclick());
                }
                if (optMap.get("onplothover") != null) {
                    this.plothoverHandlers.put((Object)new RawJSONString(optMap.get("onplothover").toString()));
                } else {
                    this.plothoverHandlers.put((Object)s.getOnplothover());
                }
                if (model == null) {
                    VisitSeries seriesCallback = new VisitSeries(s.getType());
                    s.visitTree(VisitContext.createVisitContext((FacesContext)FacesContext.getCurrentInstance()), seriesCallback);
                    model = seriesCallback.getModel();
                    if (model == null) {
                        switch (s.getType()) {
                            case line: {
                                model = new NumberChartDataModel(ChartDataModel.ChartType.line);
                                break;
                            }
                            case bar: {
                                model = new NumberChartDataModel(ChartDataModel.ChartType.bar);
                                break;
                            }
                            case pie: {
                                model = new StringChartDataModel(ChartDataModel.ChartType.pie);
                                break;
                            }
                        }
                    } else {
                        this.nodata = false;
                    }
                } else {
                    this.nodata = false;
                }
                model.setAttributes(s.getAttributes());
                try {
                    if (this.chartType == null && !this.nodata) {
                        this.chartType = model.getType();
                        this.keyType = model.getKeyType();
                        this.valType = model.getValueType();
                    } else if (this.chartType == ChartDataModel.ChartType.pie) {
                        throw new IllegalArgumentException("Pie chart supports only one series.");
                    }
                    if (this.keyType != model.getKeyType() || this.valType != model.getValueType()) {
                        throw new IllegalArgumentException("Data model is not valid for this chart type.");
                    }
                    this.data.put(model.export());
                }
                catch (IOException ex) {
                    throw new FacesException((Throwable)ex);
                }
            } else if (target instanceof AbstractXAxis) {
                this.copyAttrs(target, (UIComponent)this.chart, ChartRendererBase.X_VALUE, Arrays.asList("min", "max", "pad", "label", "format"));
            } else if (target instanceof AbstractYAxis) {
                this.copyAttrs(target, (UIComponent)this.chart, ChartRendererBase.Y_VALUE, Arrays.asList("min", "max", "pad", "label", "format"));
            }
            return VisitResult.ACCEPT;
        }

        public boolean isDataEmpty() {
            return this.nodata;
        }

        public JSONArray getData() {
            return this.data;
        }

        public Class getKeyType() {
            return this.keyType;
        }

        public Class getValType() {
            return this.valType;
        }

        public ChartDataModel.ChartType getChartType() {
            return this.chartType;
        }

        public JSONObject getSeriesSpecificHandlers() {
            return this.particularSeriesHandlers;
        }

        public List<MethodExpression> getParticularSeriesListeners() {
            return this.particularSeriesListeners;
        }
    }
}

