/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;
import org.jboss.seam.web.Session;

@Scope(value=ScopeType.STATELESS)
@Name(value="org.jboss.seam.core.conversationStackFactory")
@Install(precedence=0)
@BypassInterceptors
public class ConversationStack {
    protected List<ConversationEntry> createConversationEntryStack() {
        ConversationEntries conversationEntries = ConversationEntries.getInstance();
        if (conversationEntries == null) {
            return Collections.EMPTY_LIST;
        }
        ConversationEntry currentConversationEntry = Manager.instance().getCurrentConversationEntry();
        if (currentConversationEntry == null) {
            return Collections.EMPTY_LIST;
        }
        List<String> idStack = currentConversationEntry.getConversationIdStack();
        ArrayList<ConversationEntry> conversationEntryStack = new ArrayList<ConversationEntry>(conversationEntries.size());
        ListIterator<String> ids = idStack.listIterator(idStack.size());
        while (ids.hasPrevious()) {
            ConversationEntry entry = conversationEntries.getConversationEntry(ids.previous());
            if (!entry.isDisplayable() || Session.instance().isInvalid()) continue;
            conversationEntryStack.add(entry);
        }
        return conversationEntryStack;
    }

    @Factory(value="org.jboss.seam.core.conversationStack", autoCreate=true, scope=ScopeType.PAGE)
    public List<ConversationEntry> getConversationEntryStack() {
        return this.createConversationEntryStack();
    }
}

