/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.push.impl.jms;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.ajax4jsf.javascript.JSLiteral;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.push.Topic;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.impl.TopicsContextImpl;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class JMSTopicsContextImpl
extends TopicsContextImpl {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private final InitialContext initialContext;
    private final Name connectionFactoryName;
    private final Name topicsNamespace;
    private final String username;
    private final String password;
    private final LoadingCache<String, JMSConsumerContext> jmsConsumerContexts = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, JMSConsumerContext>(){

        public JMSConsumerContext apply(String name) {
            JMSConsumerContext topicContext = new JMSConsumerContext(name);
            try {
                topicContext.start();
            }
            catch (Exception e) {
                try {
                    topicContext.stop();
                }
                catch (Exception e1) {
                    LOGGER.error(e1.getMessage(), e1);
                }
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            return topicContext;
        }
    }));

    public static JMSTopicsContextImpl getInstanceInitializedFromContext(ThreadFactory threadFactory, FacesContext facesContext) throws NamingException {
        ConfigurationService configurationService = ServiceTracker.getService(ConfigurationService.class);
        InitialContext initialContext = new InitialContext();
        NameParser nameParser = initialContext.getNameParser("");
        Name connectionFactoryName = nameParser.parse(JMSTopicsContextImpl.getConnectionFactory(facesContext, configurationService));
        Name topicsNamespace = nameParser.parse(JMSTopicsContextImpl.getTopicsNamespace(facesContext, configurationService));
        String username = JMSTopicsContextImpl.getUserName(facesContext, configurationService);
        String password = JMSTopicsContextImpl.getPassword(facesContext, configurationService);
        return new JMSTopicsContextImpl(threadFactory, initialContext, connectionFactoryName, topicsNamespace, username, password);
    }

    private JMSTopicsContextImpl(ThreadFactory threadFactory, InitialContext initialContext, Name connectionFactoryName, Name topicsNamespace, String username, String password) {
        super(threadFactory);
        this.initialContext = initialContext;
        this.connectionFactoryName = connectionFactoryName;
        this.topicsNamespace = topicsNamespace;
        this.username = username;
        this.password = password;
    }

    @Override
    protected Topic createTopic(TopicKey key) {
        Topic topic = super.createTopic(key);
        try {
            this.jmsConsumerContexts.get((Object)key.getTopicName());
        }
        catch (ExecutionException e) {
            throw new FacesException(String.format("Can't create a JMS topic %s", key), (Throwable)e);
        }
        return topic;
    }

    @Override
    public void destroy() {
        for (JMSConsumerContext jmsConsumerContext : this.jmsConsumerContexts.asMap().values()) {
            try {
                jmsConsumerContext.stop();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        super.destroy();
    }

    private static String getConnectionFactory(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSTopicsContextImpl.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionFactory, CoreConfiguration.Items.pushJMSConnectionFactory);
    }

    private static String getTopicsNamespace(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSTopicsContextImpl.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSTopicsNamespace, CoreConfiguration.Items.pushJMSTopicsNamespace);
    }

    private static String getPassword(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSTopicsContextImpl.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionPassword, CoreConfiguration.Items.pushJMSConnectionPasswordEnvRef, CoreConfiguration.Items.pushJMSConnectionPassword);
    }

    private static String getUserName(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSTopicsContextImpl.getFirstNonEmptyConfgirutationValue(facesContext, configurationService, CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionUsername, CoreConfiguration.Items.pushJMSConnectionUsernameEnvRef, CoreConfiguration.Items.pushJMSConnectionUsername);
    }

    private static String getFirstNonEmptyConfgirutationValue(FacesContext facesContext, ConfigurationService service, Enum<?> ... keys) {
        for (Enum<?> key : keys) {
            String value = service.getStringValue(facesContext, key);
            if (Strings.isNullOrEmpty((String)value)) continue;
            return value;
        }
        return "";
    }

    private class JMSConsumerContext {
        private static final String SUBTOPIC_PROPERTY = "rf_push_subtopic";
        private static final String SERIALIZED_DATA_INDICATOR = "org_richfaces_push_SerializedData";
        private final String name;
        private Connection connection;
        private Session session;
        private Thread pollingThread;
        private MessageConsumer consumer;

        public JMSConsumerContext(String name) {
            this.name = name;
        }

        public synchronized void start() throws NamingException, JMSException {
            this.connection = this.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.consumer = this.session.createConsumer((Destination)this.lookupTopic(), null, false);
            this.pollingThread = JMSTopicsContextImpl.this.getThreadFactory().newThread(new Runnable(){

                @Override
                public void run() {
                    block4: while (true) {
                        try {
                            Message message;
                            while ((message = JMSConsumerContext.this.consumer.receive()) != null) {
                                String subtopicName = message.getStringProperty(JMSConsumerContext.SUBTOPIC_PROPERTY);
                                TopicKey topicKey = new TopicKey(JMSConsumerContext.this.name, subtopicName);
                                Topic pushTopic = JMSTopicsContextImpl.this.getOrCreateTopic(topicKey);
                                if (pushTopic == null) continue;
                                try {
                                    Object messageData = JMSConsumerContext.this.getMessageData(message);
                                    pushTopic.publish(messageData);
                                    continue block4;
                                }
                                catch (Exception e) {
                                    LOGGER.error(e.getMessage(), e);
                                }
                            }
                            break;
                        }
                        catch (JMSException e) {
                            LOGGER.error(e.getMessage(), e);
                            break;
                        }
                    }
                }
            });
            this.pollingThread.start();
        }

        public synchronized void stop() {
            if (this.consumer != null) {
                try {
                    this.consumer.close();
                    this.consumer = null;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
            if (this.session != null) {
                try {
                    this.session.close();
                    this.session = null;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.connection = null;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }

        private Connection createConnection() throws JMSException, NamingException {
            ConnectionFactory connectionFactory = (ConnectionFactory)JMSTopicsContextImpl.this.initialContext.lookup(JMSTopicsContextImpl.this.connectionFactoryName);
            Connection connection = connectionFactory.createConnection(JMSTopicsContextImpl.this.username, JMSTopicsContextImpl.this.password);
            connection.start();
            return connection;
        }

        private javax.jms.Topic lookupTopic() throws NamingException {
            Name topicName = this.appendToName(JMSTopicsContextImpl.this.topicsNamespace, this.name);
            return (javax.jms.Topic)JMSTopicsContextImpl.this.initialContext.lookup(topicName);
        }

        private Name appendToName(Name name, String comp) throws NamingException {
            Name clonedName = (Name)name.clone();
            return clonedName.add(comp);
        }

        private Object getMessageData(Message message) throws JMSException {
            Object messageData = null;
            if (message instanceof ObjectMessage) {
                messageData = ((ObjectMessage)message).getObject();
            } else if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                messageData = message.getBooleanProperty(SERIALIZED_DATA_INDICATOR) ? new JSLiteral(textMessage.getText()) : textMessage.getText();
            }
            return messageData;
        }
    }
}

