/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.admin.repo.RepoStat;
import org.nuxeo.ecm.admin.repo.RepoStatInfo;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.admin.runtime.RuntimeInstrospection;
import org.nuxeo.ecm.admin.runtime.SimplifiedServerInfo;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.storage.sql.management.SQLRepositoryStatus;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

@Name(value="systemInfo")
@Scope(value=ScopeType.CONVERSATION)
public class SystemInfoManager
implements Serializable {
    private static final Log log = LogFactory.getLog(SystemInfoManager.class);
    protected static final String RESTART_PATH = "site/connectClient/restartView";
    private static final long serialVersionUID = 1L;
    protected List<Repository> repositories;
    protected String currentRepositoryName;
    protected RepoStat runningStat;
    protected RepoStatInfo statResult;
    protected volatile boolean binaryManagerStatusInvalidation;
    protected volatile BinaryManagerStatus binaryManagerStatus;
    protected boolean binariesGCDelete;
    protected boolean binariesWereDeleted;

    public String getHostInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nOS : ");
        sb.append(System.getProperty("os.name"));
        sb.append(" (");
        sb.append(System.getProperty("os.arch"));
        sb.append(")");
        sb.append("\n");
        sb.append("\nCPU(s) : ");
        sb.append(Runtime.getRuntime().availableProcessors());
        sb.append("\n");
        sb.append("\nJVM : ");
        sb.append(System.getProperty("java.runtime.name"));
        sb.append(" ");
        sb.append(System.getProperty("java.runtime.version"));
        sb.append(" - build ");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(" (");
        sb.append(System.getProperty("java.vendor"));
        sb.append(")");
        sb.append("\n");
        sb.append("\nPlatform language : ");
        sb.append(System.getProperty("user.language"));
        sb.append("  ");
        sb.append(System.getenv("LANG"));
        sb.append("\n");
        sb.append("\nJava Memory:");
        sb.append("\n  Heap size  : ");
        sb.append(Runtime.getRuntime().totalMemory() / 0x100000L);
        sb.append(" MB");
        sb.append("\n  Used       : ");
        sb.append((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
        sb.append(" MB");
        sb.append("\n  Free       : ");
        sb.append(Runtime.getRuntime().freeMemory() / 0x100000L);
        sb.append(" MB");
        sb.append("\n  Max size   : ");
        sb.append(Runtime.getRuntime().maxMemory() / 0x100000L);
        sb.append(" MB");
        return sb.toString();
    }

    public String getUptime() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        long ut = bean.getUptime();
        long uts = ut / 1000L;
        StringBuffer sb = new StringBuffer("Nuxeo Server UpTime : ");
        long nbDays = uts / 86400L;
        if (nbDays > 0L) {
            sb.append(nbDays + " days, ");
            uts %= 86400L;
        }
        long nbHours = uts / 3600L;
        sb.append(nbHours + " h ");
        long nbMin = (uts %= 3600L) / 60L;
        sb.append(nbMin + " m ");
        sb.append((uts %= 60L) + " s  ");
        return sb.toString();
    }

    @Factory(value="nuxeoPlatformIdentifier", scope=ScopeType.APPLICATION)
    public String getNuxeoPlatformIdentifier() {
        return PlatformVersionHelper.getPlatformFilter();
    }

    @Factory(value="nuxeoServerInfo", scope=ScopeType.EVENT)
    public SimplifiedServerInfo getNuxeoServerInfo() {
        return RuntimeInstrospection.getInfo();
    }

    public boolean isBundleDeployed(String bundleId) {
        return RuntimeInstrospection.getBundleIds().contains(bundleId);
    }

    public boolean isMultiRepo() {
        return this.listAvailableRepositories().size() > 1;
    }

    public List<Repository> listAvailableRepositories() {
        if (this.repositories == null) {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            this.repositories = new ArrayList<Repository>(repositoryManager.getRepositories());
            this.currentRepositoryName = repositoryManager.getDefaultRepositoryName();
        }
        return this.repositories;
    }

    public String getCurrentRepositoryName() {
        if (this.currentRepositoryName == null) {
            this.listAvailableRepositories();
        }
        return this.currentRepositoryName;
    }

    public void setCurrentRepositoryName(String name) {
        this.currentRepositoryName = name;
    }

    public int getOpenSessionNumber() {
        return CoreInstance.getInstance().getNumberOfSessions();
    }

    public int getActiveSessionNumber() {
        SQLRepositoryStatus status = new SQLRepositoryStatus();
        return status.getActiveSessionsCount();
    }

    public void startRepoStats() {
        if (this.runningStat != null) {
            return;
        }
        this.statResult = null;
        this.runningStat = new RepoStat(this.getCurrentRepositoryName(), 5, true);
        this.runningStat.run((DocumentRef)new PathRef("/"));
    }

    public boolean isStatInfoInProgress() {
        if (this.isStatInfoAvailable()) {
            return false;
        }
        return this.runningStat != null;
    }

    public boolean isStatInfoAvailable() {
        if (this.statResult != null) {
            return true;
        }
        if (this.runningStat != null && !this.runningStat.isRunning()) {
            this.statResult = this.runningStat.getInfo();
            Contexts.getEventContext().remove("repoStatResult");
            this.runningStat = null;
            return true;
        }
        return false;
    }

    @Factory(value="repoStatResult", scope=ScopeType.EVENT)
    public RepoStatInfo getStatInfo() {
        return this.statResult;
    }

    public String getRepoUsage() {
        StringBuilder sb = new StringBuilder();
        int nbSessions = CoreInstance.getInstance().getNumberOfSessions();
        sb.append("Number of open repository session : ");
        sb.append(nbSessions);
        RepoStat stat = new RepoStat("default", 5, true);
        stat.run((DocumentRef)new PathRef("/"));
        try {
            Thread.sleep(100L);
            do {
                Thread.sleep(1000L);
            } while (stat.isRunning());
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.runtimeException((Exception)e);
        }
        sb.append(stat.getInfo().toString());
        return sb.toString();
    }

    public String restartServer() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)Boolean.TRUE);
        String restartUrl = BaseURL.getBaseURL((ServletRequest)request) + RESTART_PATH;
        try {
            context.getExternalContext().redirect(restartUrl);
        }
        catch (IOException e) {
            log.error((Object)"Error while redirecting to restart page", (Throwable)e);
        }
        return null;
    }

    public void setBinariesGCDelete(boolean binariesGCDelete) {
        this.binariesGCDelete = binariesGCDelete;
    }

    public boolean getBinariesGCDelete() {
        return this.binariesGCDelete;
    }

    public boolean getBinariesWereDeleted() {
        return this.binariesWereDeleted;
    }

    public void startBinariesGC() {
        if (this.isBinariesGCInProgress()) {
            return;
        }
        this.binaryManagerStatus = null;
        this.binaryManagerStatusInvalidation = false;
        BinariesGCTask gcTask = new BinariesGCTask(this.binariesGCDelete);
        Thread t = new Thread((Runnable)gcTask, "NuxeoBinariesGCUI");
        t.setDaemon(true);
        t.start();
        this.binariesWereDeleted = this.binariesGCDelete;
        this.binariesGCDelete = false;
    }

    public boolean isBinariesGCInProgress() {
        return new SQLRepositoryStatus().isBinariesGCInProgress();
    }

    public boolean isBinaryManagerStatusAvailable() {
        if (this.binaryManagerStatusInvalidation) {
            Contexts.getEventContext().remove("binaryManagerStatus");
            this.binaryManagerStatusInvalidation = false;
        }
        return this.binaryManagerStatus != null;
    }

    @Factory(value="binaryManagerStatus", scope=ScopeType.EVENT)
    public BinaryManagerStatus getBinaryManagerStatus() {
        return this.binaryManagerStatus;
    }

    public class BinariesGCTask
    implements Runnable {
        public boolean delete;

        public BinariesGCTask(boolean delete) {
            this.delete = delete;
        }

        @Override
        public void run() {
            try {
                SystemInfoManager.this.binaryManagerStatus = new SQLRepositoryStatus().gcBinaries(this.delete);
                SystemInfoManager.this.binaryManagerStatusInvalidation = true;
            }
            catch (RuntimeException e) {
                log.error((Object)"Error while executing BinariesGCTask", (Throwable)e);
            }
        }
    }
}

